/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.ActorUtils;
import adams.flow.source.AbstractDatabaseIdSupplier;
import adams.flow.standalone.DatabaseConnection;
import java.sql.ResultSet;
import java.util.ArrayList;

public class SQLIdSupplier
extends AbstractDatabaseIdSupplier {
    private static final long serialVersionUID = -2269772801929933064L;
    protected SQLStatement m_SQL;
    protected Type m_Type;

    @Override
    public String globalInfo() {
        return "Executes an SQL statement for generating the IDs.\nVariables are automatically expanded.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sql", "SQL", new SQLStatement("select auto_id from table"));
        this.m_OptionManager.add("type", "type", (Object)Type.INTEGER);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "type", (Object)this.m_Type);
        result = result + QuickInfoHelper.toString((OptionHandler)this, "SQL", Utils.shorten(this.m_SQL.getValue().replaceAll("\\s", " ").replaceAll("[ ]+", " "), 50), ": ");
        return result;
    }

    public void setSQL(SQLStatement value) {
        this.m_SQL = value;
        this.reset();
    }

    public SQLStatement getSQL() {
        return this.m_SQL;
    }

    public String SQLTipText() {
        return "The SQL statement to run that generates the IDs.";
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of IDs to generate.";
    }

    @Override
    protected Class getItemClass() {
        switch (this.m_Type) {
            case INTEGER: {
                return Integer.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    @Override
    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection(this, DatabaseConnection.class, adams.db.DatabaseConnection.getSingleton());
    }

    @Override
    protected ArrayList getIDs() {
        ArrayList<Object> result = new ArrayList<Object>();
        ResultSet rs = null;
        try {
            SQL sql = new SQL(this.getDatabaseConnection());
            String query = this.m_SQL.getValue();
            query = this.getVariables().expand(query);
            if (this.isDebugOn()) {
                this.debug("Query: " + query);
            }
            rs = sql.getResultSet(query);
            block6: while (rs.next()) {
                switch (this.m_Type) {
                    case INTEGER: {
                        result.add(rs.getInt(1));
                        continue block6;
                    }
                    case STRING: {
                        result.add(rs.getString(1));
                        continue block6;
                    }
                }
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
            }
            if (this.isDebugOn()) {
                this.debug("--> " + result.size() + " IDs");
            }
        }
        catch (Exception e) {
            this.handleException("Failed to obtain IDs: ", e);
        }
        SQL.closeAll(rs);
        return result;
    }

    public static enum Type {
        INTEGER,
        STRING;

    }
}

