/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSource;

public class StorageValue
extends AbstractSource {
    private static final long serialVersionUID = -44192504096493397L;
    protected String m_Cache;
    protected StorageName m_StorageName;
    protected Object m_StoredValue;

    @Override
    public String globalInfo() {
        return "Outputs the value associated with the specified name from temporary storage.\nBy supplying a cache name, the value can be obtained from a LRU cache instead of the regular storage.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to retrieve the value from; uses the regular storage if left empty.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to retrieve.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName);
        String value = QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.length() > 0 ? this.m_Cache : "", " cache: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_StoredValue = null;
    }

    @Override
    protected String performSetUpChecks(boolean fromSetUp) {
        String result = super.performSetUpChecks(fromSetUp);
        if (result == null && this.canPerformSetUpCheck(fromSetUp, "storageName") && (this.m_StorageName == null || this.m_StorageName.getValue().length() == 0)) {
            result = "No name specified for storage value!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.m_Cache.length() == 0) {
            if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                this.m_StoredValue = this.getStorageHandler().getStorage().get(this.m_StorageName);
            }
        } else if (this.getStorageHandler().getStorage().has(this.m_Cache, this.m_StorageName)) {
            this.m_StoredValue = this.getStorageHandler().getStorage().get(this.m_Cache, this.m_StorageName);
        }
        return null;
    }

    @Override
    public Token output() {
        Token result = new Token(this.m_StoredValue);
        this.m_StoredValue = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_StoredValue != null;
    }
}

