/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.DirectoryLister;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;
import java.io.File;
import java.util.ArrayList;

public class DeleteFile
extends AbstractStandalone {
    private static final long serialVersionUID = 4670761846363281951L;
    protected DirectoryLister m_Lister;

    @Override
    public String globalInfo() {
        return "Deletes the files/dirs that match the regular expression below the specified directory.\nIn case of directories, deletion is performed recursively (if a directory matches, then the content gets deleted regardless whether it matches the regular expression or not).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("recursive", "recursive", false);
        this.m_OptionManager.add("max-depth", "maxDepth", -1);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Lister = new DirectoryLister();
        this.m_Lister.setListFiles(true);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "directory", this.getDirectory());
        result = result + QuickInfoHelper.toString((OptionHandler)this, "regExp", this.getRegExp(), File.separator);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "recursive", this.getRecursive(), "(recursive)"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Lister.setWatchDir(value);
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Lister.getWatchDir();
    }

    public String directoryTipText() {
        return "The directory to delete the files in.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_Lister.setRegExp(value);
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_Lister.getRegExp();
    }

    public String regExpTipText() {
        return "The regular expression that the files/dirs must match (empty string matches all).";
    }

    public void setRecursive(boolean value) {
        this.m_Lister.setRecursive(value);
        this.reset();
    }

    public boolean getRecursive() {
        return this.m_Lister.getRecursive();
    }

    public String recursiveTipText() {
        return "Whether to search recursively or not.";
    }

    public void setMaxDepth(int value) {
        this.m_Lister.setMaxDepth(value);
        this.reset();
    }

    public int getMaxDepth() {
        return this.m_Lister.getMaxDepth();
    }

    public String maxDepthTipText() {
        return "The maximum depth to search in recursive mode (1 = only watch directory, -1 = infinite).";
    }

    @Override
    protected String doExecute() {
        String result = null;
        String[] files = this.m_Lister.list();
        for (int i = 0; i < files.length; ++i) {
            File file = new File(files[i]);
            String type = file.isDirectory() ? "directory" : "file";
            try {
                if (this.isDebugOn()) {
                    this.debug(type + " '" + file + "' exists: " + file.exists());
                }
                if (!file.exists()) continue;
                boolean deleted = FileUtils.delete(file);
                if (!this.isDebugOn()) continue;
                this.debug(type + " '" + file + "' deleted: " + deleted);
                continue;
            }
            catch (Exception e) {
                result = this.handleException("Problem deleting " + type + " '" + file + "': ", e);
            }
        }
        return result;
    }
}

