/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;

public class MakeDir
extends AbstractStandalone {
    private static final long serialVersionUID = -4834816502537753658L;
    protected PlaceholderDirectory m_Directory;

    @Override
    public String globalInfo() {
        return "Creates the user-supplied directory if not already existing. The actor automatically creates all missing directories in the directory hierarchy.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir", "directory", new PlaceholderDirectory("."));
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "directory", this.m_Directory);
    }

    public void setDirectory(PlaceholderDirectory value) {
        this.m_Directory = value;
        this.reset();
    }

    public PlaceholderDirectory getDirectory() {
        return this.m_Directory;
    }

    public String directoryTipText() {
        return "The directory to create, if necessary.";
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            this.debug("Directory '" + this.m_Directory + "' exists: " + this.m_Directory.exists());
            if (!this.m_Directory.exists() && !this.m_Directory.mkdirs()) {
                String string = "Error creating directory '" + this.m_Directory + "'!";
            }
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to create directory: " + this.m_Directory, e);
        }
        return result;
    }
}

