/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.flow.standalone.AbstractStandalone;

public class SetVariable
extends AbstractStandalone {
    private static final long serialVersionUID = -3383735680425581504L;
    protected VariableName m_VariableName;
    protected String m_VariableValue;

    @Override
    public String globalInfo() {
        return "Sets the value of a global variable.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
        this.m_OptionManager.add("var-value", "variableValue", "value");
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    public void setVariableValue(String value) {
        this.m_VariableValue = value;
        this.reset();
    }

    public String getVariableValue() {
        return this.m_VariableValue;
    }

    public String variableValueTipText() {
        return "The value for the variable to use.";
    }

    @Override
    public String getQuickInfo() {
        String variable = QuickInfoHelper.getVariable(this, "variableName");
        String result = variable != null ? "@{" + variable + "}" : this.m_VariableName.paddedValue();
        String value = QuickInfoHelper.toString((OptionHandler)this, "variableValue", this.m_VariableValue, " = ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        this.getVariables().set(this.m_VariableName.getValue(), this.m_VariableValue);
        if (this.isDebugOn()) {
            this.debug("Setting variable '" + this.m_VariableName + "': " + this.m_VariableValue);
        }
        return result;
    }
}

