/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.template;

import adams.core.CleanUpHandler;
import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.template.AbstractActorTemplate;

public abstract class AbstractScriptTemplate
extends AbstractActorTemplate
implements CleanUpHandler {
    private static final long serialVersionUID = -6644860566598093960L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "scriptFile", new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim());
    }

    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    protected abstract AbstractActor executeScript();

    @Override
    protected AbstractActor doGenerate() {
        String msg = this.initScriptObject();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.executeScript();
    }

    @Override
    public void cleanUp() {
    }
}

