/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.db.DataProvider;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractDbTransformer;
import adams.flow.transformer.datacontainer.AbstractDataContainerPreProcessor;
import adams.flow.transformer.datacontainer.NoPreProcessing;

public abstract class AbstractDataContainerDbWriter<T extends DataContainer & DatabaseIDHandler>
extends AbstractDbTransformer {
    private static final long serialVersionUID = -7382952208593440101L;
    protected AbstractDataContainerPreProcessor m_PreProcessor;
    protected boolean m_OverwriteExisting;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pre-processor", "preProcessor", new NoPreProcessing());
        this.m_OptionManager.add("overwrite-existing", "overwriteExisting", false);
    }

    public void setPreProcessor(AbstractDataContainerPreProcessor value) {
        this.m_PreProcessor = value;
        this.reset();
    }

    public AbstractDataContainerPreProcessor getPreProcessor() {
        return this.m_PreProcessor;
    }

    public String preProcessorTipText() {
        return "The pre-processor to apply to the data.";
    }

    public void setOverwriteExisting(boolean value) {
        this.m_OverwriteExisting = value;
        this.reset();
    }

    public boolean getOverwriteExisting() {
        return this.m_OverwriteExisting;
    }

    public abstract String overwriteExistingTipText();

    @Override
    public abstract Class[] accepts();

    @Override
    public Class[] generates() {
        return new Class[]{Integer.class};
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "preProcessor", this.m_PreProcessor);
        String value = QuickInfoHelper.toString((OptionHandler)this, "overwriteExisting", this.m_OverwriteExisting, "overwrite", ", ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    protected abstract DataProvider<T> getDataProvider(T var1);

    protected boolean exists(DataProvider provider, T cont) {
        return provider.exists(cont.getID());
    }

    protected boolean remove(DataProvider provider, T cont) {
        return provider.remove(cont.getID());
    }

    protected Integer add(DataProvider provider, T cont) {
        return provider.add(cont);
    }

    protected Integer store(T cont) {
        Integer result = -1;
        DataProvider<T> provider = this.getDataProvider(cont);
        boolean exists = this.exists(provider, cont);
        if (this.isDebugOn()) {
            this.debug("Container '" + cont + "' exists in database: " + exists);
        }
        if (exists) {
            if (this.m_OverwriteExisting) {
                boolean ok = this.remove(provider, cont);
                if (this.isDebugOn()) {
                    this.debug("Existing container '" + cont + "' removed from database: " + ok);
                }
                if (ok) {
                    result = this.add(provider, cont);
                } else {
                    this.getSystemErr().println("Failed to remove container from database: " + cont);
                }
            } else {
                this.getSystemErr().println("Container '" + cont + "' already exists in database, but no overwrite allowed, skipping!");
            }
        } else {
            result = this.add(provider, cont);
        }
        return result;
    }

    protected T preProcess(T cont) {
        return this.m_PreProcessor.preProcess(cont);
    }

    @Override
    protected String queryDatabase() {
        String result = null;
        DataContainer cont = (DataContainer)this.m_InputToken.getPayload();
        Integer id = this.store(this.preProcess(cont));
        if (id == null) {
            result = "Error saving container: " + this.m_InputToken;
        } else {
            this.m_OutputToken = new Token(id);
        }
        return result;
    }
}

