/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.data.CompressionSupporter;
import adams.data.DataUtils;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.data.io.output.AbstractDataContainerWriter;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;

public abstract class AbstractDataContainerFileWriter<T extends DataContainer>
extends AbstractTransformer {
    private static final long serialVersionUID = -2589436559371405252L;
    protected AbstractDataContainerWriter<T> m_Writer;
    protected PlaceholderDirectory m_OutputDir;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("writer", "writer", this.getDefaultWriter());
        this.m_OptionManager.add("dir", "outputDir", new PlaceholderDirectory("."));
    }

    protected abstract AbstractDataContainerWriter<T> getDefaultWriter();

    public void setWriter(AbstractDataContainerWriter value) {
        this.m_Writer = value;
        this.reset();
    }

    public AbstractDataContainerWriter getWriter() {
        return this.m_Writer;
    }

    public String writerTipText() {
        return "The writer to use for saving the data.";
    }

    public void setOutputDir(PlaceholderDirectory value) {
        this.m_OutputDir = value;
        this.reset();
    }

    public PlaceholderDirectory getOutputDir() {
        return this.m_OutputDir;
    }

    public String outputDirTipText() {
        return "The output directory for the data.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "writer", this.m_Writer);
    }

    protected abstract Class getDataContainerClass();

    @Override
    public Class[] accepts() {
        Class<?> cls = Array.newInstance(this.getDataContainerClass(), 0).getClass();
        return new Class[]{cls.getComponentType(), cls};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        DataContainer cont;
        DataContainer[] conts;
        String result = null;
        if (this.m_InputToken.getPayload().getClass().isArray()) {
            conts = (DataContainer[])this.m_InputToken.getPayload();
            cont = conts[0];
        } else {
            conts = null;
            cont = (DataContainer)this.m_InputToken.getPayload();
        }
        PlaceholderFile file = this.m_Writer.isOutputFile() ? (this.m_Writer instanceof CompressionSupporter && ((CompressionSupporter)((Object)this.m_Writer)).getUseCompression() ? new PlaceholderFile(DataUtils.createFilename((File)this.m_OutputDir, (Object)cont, "." + this.m_Writer.getFormatExtensions()[0] + ".gz")) : new PlaceholderFile(DataUtils.createFilename((File)this.m_OutputDir, (Object)cont, "." + this.m_Writer.getFormatExtensions()[0]))) : new PlaceholderFile(DataUtils.createFilename((File)this.m_OutputDir, (Object)cont, null));
        this.m_Writer.setOutput(file);
        try {
            boolean success = conts != null ? this.m_Writer.write(Arrays.asList(conts)) : this.m_Writer.write(cont);
            if (!success) {
                result = "Failed to write data to '" + file + "'!";
            }
            if (this.isDebugOn()) {
                if (conts != null) {
                    this.debug(conts.length + " containers written to " + file);
                } else if (cont instanceof DatabaseIDHandler) {
                    this.debug("Container #" + ((DatabaseIDHandler)((Object)cont)).getDatabaseID() + " written to " + file);
                } else {
                    this.debug("Container " + cont + " written to " + file);
                }
            }
            this.m_Writer.cleanUp();
            if (success) {
                this.m_OutputToken = new Token(file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            result = this.handleException("Error writing container(s) to '" + file + "': ", e);
            return result;
        }
        return result;
    }
}

