/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.db.DatabaseConnectionHandler;
import adams.db.ReportProvider;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractDbDataProcessor;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public abstract class AbstractReportFileImport<T extends Report>
extends AbstractDbDataProcessor
implements ProvenanceSupporter {
    private static final long serialVersionUID = -4427045123505865448L;
    public static final String BACKUP_IDS = "ids";
    public static final String BACKUP_REPORTS = "reports";
    protected Vector<Integer> m_IDs;
    protected Vector<T> m_Reports;
    protected AbstractReportReader<T> m_Reader;
    protected boolean m_RemoveExisting;
    protected boolean m_Import;
    protected boolean m_Forward;
    protected boolean m_Merge;
    protected Field[] m_OverwriteFields;

    @Override
    public String globalInfo() {
        return "Imports quantitation reports into the database.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reader", "reader", this.getDefaultReader());
        this.m_OptionManager.add("remove", "removeExisting", false);
        this.m_OptionManager.add("forward", "forward", false);
        this.m_OptionManager.add("import", "import", true);
        this.m_OptionManager.add("merge", "merge", false);
        this.m_OptionManager.add("overwrite", "overwriteFields", new Field[0]);
    }

    protected abstract AbstractReportReader<T> getDefaultReader();

    public void setReader(AbstractReportReader value) {
        this.m_Reader = value;
        if (this.m_Reader instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)this.m_Reader)).setDatabaseConnection(this.m_DatabaseConnection);
        }
        this.reset();
    }

    public AbstractReportReader getReader() {
        return this.m_Reader;
    }

    public String readerTipText() {
        return "The reader used for loading the reports.";
    }

    public void setRemoveExisting(boolean value) {
        this.m_RemoveExisting = value;
        this.reset();
    }

    public boolean getRemoveExisting() {
        return this.m_RemoveExisting;
    }

    public String removeExistingTipText() {
        return "If true then existing reports will be removed first completely from the database before the current one is saved.";
    }

    public void setForward(boolean value) {
        this.m_Forward = value;
        this.reset();
    }

    public boolean getForward() {
        return this.m_Forward;
    }

    public String forwardTipText() {
        return "If set to true then the reports are forwarded instead of the IDs.";
    }

    public void setImport(boolean value) {
        this.m_Import = value;
        this.reset();
    }

    public boolean getImport() {
        return this.m_Import;
    }

    public String importTipText() {
        return "If set to true then the reports are imported into the database.";
    }

    public void setMerge(boolean value) {
        this.m_Merge = value;
        this.reset();
    }

    public boolean getMerge() {
        return this.m_Merge;
    }

    public String mergeTipText() {
        return "If true then the information in the current report is only added to the existing one (but 'Dummy report' is always set to 'false').";
    }

    public void setOverwriteFields(Field[] value) {
        this.m_OverwriteFields = value;
        this.reset();
    }

    public Field[] getOverwriteFields() {
        return this.m_OverwriteFields;
    }

    public String overwriteFieldsTipText() {
        return "The fields to overwrite with the new data when in 'merge' mode.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_IDS);
        this.pruneBackup(BACKUP_REPORTS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_IDS, this.m_IDs);
        result.put(BACKUP_REPORTS, this.m_Reports);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_IDS)) {
            this.m_IDs = (Vector)state.get(BACKUP_IDS);
            state.remove(BACKUP_IDS);
        }
        if (state.containsKey(BACKUP_REPORTS)) {
            this.m_Reports = (Vector)state.get(BACKUP_REPORTS);
            state.remove(BACKUP_REPORTS);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_IDs = new Vector();
        this.m_Reports = new Vector();
    }

    protected abstract ReportProvider<T> getReportProvider();

    @Override
    protected String setUpDatabaseConnection() {
        String result = null;
        if (this.m_DatabaseConnection == null && (result = super.setUpDatabaseConnection()) == null && (this.m_Import || this.m_Reader instanceof DatabaseConnectionHandler)) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_Reader instanceof DatabaseConnectionHandler) {
                ((DatabaseConnectionHandler)((Object)this.m_Reader)).setDatabaseConnection(this.m_DatabaseConnection);
            }
        }
        return result;
    }

    @Override
    protected boolean processData(File file) {
        boolean result = false;
        this.m_Reader.setInput(new PlaceholderFile(file));
        if (this.isDebugOn()) {
            this.debug("Attempting to load '" + file + "'");
        }
        Vector<T> reports = this.m_Reader.read();
        for (Report report : reports) {
            if (this.m_Import) {
                ReportProvider<Report> provider = this.getReportProvider();
                result = provider.store(report.getDatabaseID(), report, this.m_RemoveExisting, this.m_Merge, this.m_OverwriteFields);
                if (this.m_Forward) {
                    this.m_Reports.add(report);
                    continue;
                }
                if (result) {
                    this.m_IDs.add(report.getDatabaseID());
                    continue;
                }
                this.m_IDs.add(-1);
                continue;
            }
            if (!this.m_Forward) continue;
            this.m_Reports.add(report);
            result = true;
        }
        return result;
    }

    protected abstract Class getReportClass();

    @Override
    public Class[] generates() {
        if (this.m_Forward) {
            return new Class[]{this.getReportClass()};
        }
        if (this.m_Import) {
            return new Class[]{Integer.class};
        }
        return new Class[0];
    }

    @Override
    public Token output() {
        Token result = null;
        if (this.m_Forward) {
            result = new Token(this.m_Reports.get(0));
            this.m_Reports.remove(0);
            this.updateProvenance(result);
        } else if (this.m_Import) {
            result = new Token(this.m_IDs.get(0));
            this.m_IDs.remove(0);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        if (this.m_Forward) {
            return this.m_Reports.size() > 0;
        }
        if (this.m_Import) {
            return this.m_IDs.size() > 0;
        }
        return false;
    }

    @Override
    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this, ((Token)cont).getPayload().getClass()));
        }
    }
}

