/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.Serializable;

public class ArrayStatistic
extends AbstractTransformer {
    private static final long serialVersionUID = 8536100625511019961L;
    protected DataType m_DataType;
    protected BaseString[] m_Locations;
    protected AbstractArrayStatistic m_Statistic;

    @Override
    public String globalInfo() {
        return "Generates statistics from a double array or matrix.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "dataType", (Object)DataType.COLUMN_BY_INDEX);
        this.m_OptionManager.add("location", "locations", new BaseString[0]);
        this.m_OptionManager.add("statistic", "statistic", new ArrayMean());
    }

    public void setDataType(DataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public DataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "In case of a double matrix, whether to retrieve rows or columns; ignored in case of simple double arrays.";
    }

    public void setLocations(BaseString[] value) {
        this.m_Locations = value;
        this.reset();
    }

    public BaseString[] getLocations() {
        return this.m_Locations;
    }

    public String locationsTipText() {
        return "The locations of the data; " + new Index().getExample();
    }

    public void setStatistic(AbstractArrayStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractArrayStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate from the data.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "statistic", this.m_Statistic);
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Double[].class, Double[][].class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    @Override
    protected String doExecute() {
        SpreadSheet sheet;
        String result = null;
        try {
            sheet = null;
            AbstractArrayStatistic stat = this.m_Statistic.shallowCopy(true);
            if (this.m_InputToken.getPayload() instanceof Double[]) {
                Serializable[] array = (Double[])this.m_InputToken.getPayload();
                stat.add(array);
            } else {
                Double[][] matrix = (Double[][])this.m_InputToken.getPayload();
                block6: for (int i = 0; i < this.m_Locations.length; ++i) {
                    switch (this.m_DataType) {
                        case ROW_BY_INDEX: {
                            Index index = new Index(this.m_Locations[i].stringValue());
                            index.setMax(matrix.length);
                            Serializable[] array = matrix[index.getIntIndex()];
                            stat.add(array);
                            continue block6;
                        }
                        case COLUMN_BY_INDEX: {
                            Index index = new Index(this.m_Locations[i].stringValue());
                            index.setMax(matrix[0].length);
                            Serializable[] array = new Double[matrix.length];
                            for (int n = 0; n < array.length; ++n) {
                                array[n] = matrix[n][index.getIntIndex()];
                            }
                            stat.add(array);
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException("Unhandlded data type: " + (Object)((Object)this.m_DataType));
                        }
                    }
                }
            }
            sheet = stat.calculate().toSpreadSheet();
        }
        catch (Exception e) {
            result = this.handleException("Error generating the statistic: ", e);
            sheet = null;
        }
        if (sheet != null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }

    public static enum DataType {
        ROW_BY_INDEX,
        COLUMN_BY_INDEX;

    }
}

