/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;

public class CopyFile
extends AbstractTransformer {
    private static final long serialVersionUID = 4670761846363281951L;
    protected boolean m_CreateSubDirectories;
    protected BaseRegExp m_RegExp;
    protected PlaceholderDirectory m_TargetDirectory;

    @Override
    public String globalInfo() {
        return "Copies the file received on its input port to the target directory if it matches the provided regular expression.\nIn case of a directory, the directory gets copied recursively.\nThe generated target file/directory gets forwarded in the flow.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("create-sub-dirs", "createSubDirectories", false);
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("target-dir", "targetDirectory", new PlaceholderDirectory("."));
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp.isMatchAll() ? "all" : this.m_RegExp.getValue());
        result = result + QuickInfoHelper.toString((OptionHandler)this, "targetDirectory", this.m_TargetDirectory, " -> ");
        return result;
    }

    public void setCreateSubDirectories(boolean value) {
        this.m_CreateSubDirectories = value;
        this.reset();
    }

    public boolean getCreateSubDirectories() {
        return this.m_CreateSubDirectories;
    }

    public String createSubDirectoriesTipText() {
        return "If set to true, sub directories from the last path component of the inputs are created below the target directory (eg: /some/where/blah -> TARGET/blah).";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the filename against.";
    }

    public void setTargetDirectory(PlaceholderDirectory value) {
        this.m_TargetDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getTargetDirectory() {
        return this.m_TargetDirectory;
    }

    public String targetDirectoryTipText() {
        return "The target directory to copy the files to.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class, File.class};
    }

    @Override
    protected String doExecute() {
        String result;
        PlaceholderFile file = this.m_InputToken.getPayload() instanceof File ? new PlaceholderFile((File)this.m_InputToken.getPayload()) : new PlaceholderFile((String)this.m_InputToken.getPayload());
        String type = ((File)file).isDirectory() ? "directory" : "file";
        try {
            this.debug(type + " '" + file + "' exists: " + ((File)file).exists());
            if (((File)file).exists()) {
                this.debug(type + " '" + file + "' matches '" + this.m_RegExp + "': " + this.m_RegExp.isMatch(file.getName()));
                if (this.m_RegExp.isMatch(file.getName())) {
                    File target = this.m_CreateSubDirectories && ((File)file).isDirectory() ? new File(this.m_TargetDirectory.getAbsolutePath() + File.separator + file.getName()) : this.m_TargetDirectory;
                    this.debug("Target directory: " + target);
                    FileUtils.copy(file, target);
                    this.m_OutputToken = this.m_CreateSubDirectories && ((File)file).isDirectory() || !((File)file).isDirectory() ? new Token(target.getAbsolutePath() + File.separator + file.getName()) : new Token(target.getAbsolutePath());
                }
            }
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Problem copying " + type + " '" + file + "': ", e);
        }
        return result;
    }
}

