/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class DeleteStorageValue
extends AbstractTransformer {
    private static final long serialVersionUID = 3427074997423945878L;
    protected String m_Cache;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Removes the specified value from temporary storage whenever a token passes through.\nBy supplying a cache name, the value can be removed from a LRU cache instead of the regular storage.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to remove the value from; uses the regular storage if left empty.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to delete.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName);
        String value = QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.length() > 0 ? this.m_Cache : "", " cache: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String performSetUpChecks(boolean fromSetUp) {
        String result = super.performSetUpChecks(fromSetUp);
        if (result == null && this.canPerformSetUpCheck(fromSetUp, "storageName") && (this.m_StorageName == null || this.m_StorageName.getValue().length() == 0)) {
            result = "No name specified for storing value!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.m_Cache.length() == 0) {
            this.getStorageHandler().getStorage().remove(this.m_StorageName);
        } else {
            this.getStorageHandler().getStorage().remove(this.m_Cache, this.m_StorageName);
        }
        this.m_OutputToken = this.m_InputToken;
        return null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }
}

