/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class DeleteVariable
extends AbstractTransformer {
    private static final long serialVersionUID = -3383735680425581504L;
    protected VariableName m_VariableName;

    @Override
    public String globalInfo() {
        return "Removes a global variable. Each time a token passes through, the variable will get deleted.\nThe transformer just forwards tokens that it receives after the variable has been deleted.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to update.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "variableName", this.m_VariableName.paddedValue());
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            if (this.m_InputToken.getPayload() != null) {
                String oldValue;
                if (this.getVariables().has(this.m_VariableName.getValue())) {
                    oldValue = this.getVariables().remove(this.m_VariableName.getValue());
                    if (this.isDebugOn()) {
                        this.debug("Removed scoped variable '" + this.m_VariableName.getValue() + "', value:" + oldValue);
                    }
                }
                oldValue = this.getVariables().remove(this.m_VariableName.getValue());
                if (this.isDebugOn()) {
                    this.debug("Removed variable '" + this.m_VariableName.getValue() + "', value:" + oldValue);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to delete variable: " + this.m_VariableName, e);
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }
}

