/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DiffUtils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class Diff
extends AbstractTransformer {
    private static final long serialVersionUID = -5101920243595168374L;
    protected DiffType m_Type;

    @Override
    public String globalInfo() {
        return "Compares two files to two string arrays and generates a diff representation.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)DiffType.UNIFIED);
    }

    public void setType(DiffType value) {
        this.m_Type = value;
        this.reset();
    }

    public DiffType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of diff string to generate.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String[].class, File[].class, String[][].class};
    }

    @Override
    public Class[] generates() {
        switch (this.m_Type) {
            case UNIFIED: {
                return new Class[]{String.class};
            }
            case SIDE_BY_SIDE: {
                return new Class[]{DiffUtils.SideBySideDiff.class};
            }
            case BRIEF: {
                return new Class[]{Boolean.class};
            }
        }
        throw new IllegalStateException("Unhandled diff type: " + (Object)((Object)this.m_Type));
    }

    @Override
    protected String doExecute() {
        String result = null;
        File[] files = null;
        String[] filesStr = null;
        String[][] strings = null;
        List<String> left = null;
        List<String> right = null;
        if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
            if (files.length != 2) {
                result = "Diff requires exactly two files, provided: " + files.length;
            } else {
                left = FileUtils.loadFromFile(files[0]);
                right = FileUtils.loadFromFile(files[1]);
            }
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            filesStr = (String[])this.m_InputToken.getPayload();
            if (filesStr.length != 2) {
                result = "Diff requires exactly two files, provided: " + filesStr.length;
            } else {
                left = FileUtils.loadFromFile(new PlaceholderFile(filesStr[0]));
                right = FileUtils.loadFromFile(new PlaceholderFile(filesStr[1]));
            }
        } else if (this.m_InputToken.getPayload() instanceof String[][]) {
            strings = (String[][])this.m_InputToken.getPayload();
            if (strings.length != 2) {
                result = "Diff requires exactly two string arrays, provided: " + strings.length;
            } else {
                left = Arrays.asList(strings[0]);
                right = Arrays.asList(strings[1]);
            }
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        if (result == null) {
            switch (this.m_Type) {
                case UNIFIED: {
                    this.m_OutputToken = new Token(DiffUtils.unified(left, right));
                    break;
                }
                case SIDE_BY_SIDE: {
                    this.m_OutputToken = new Token(DiffUtils.sideBySide(left, right));
                    break;
                }
                case BRIEF: {
                    this.m_OutputToken = new Token(DiffUtils.isDifferent(left, right));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled diff type: " + (Object)((Object)this.m_Type));
                }
            }
        }
        return result;
    }

    public static enum DiffType {
        BRIEF,
        UNIFIED,
        SIDE_BY_SIDE;

    }
}

