/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.JsonDataType;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import org.json.simple.JSONArray;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class GetJsonValue
extends AbstractTransformer {
    private static final long serialVersionUID = -8757919765508522198L;
    protected String m_Key;
    protected JsonDataType m_DataType;

    @Override
    public String globalInfo() {
        return "Obtains the value associated with the specified key from the JSON object passing through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", "");
        this.m_OptionManager.add("data-type", "dataType", (Object)JsonDataType.OBJECT);
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the value to retrieve.";
    }

    public void setDataType(JsonDataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public JsonDataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "The type of the data that is output.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "key", this.m_Key, "key: ");
        result = result != null ? result + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, "dataType", (Object)this.m_DataType, "data-type: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{JSONAware.class, JSONObject.class};
    }

    @Override
    public Class[] generates() {
        switch (this.m_DataType) {
            case BOOLEAN: {
                return new Class[]{Boolean.class};
            }
            case NUMBER: {
                return new Class[]{Double.class};
            }
            case STRING: {
                return new Class[]{String.class};
            }
            case OBJECT: {
                return new Class[]{JSONObject.class};
            }
            case ARRAY: {
                return new Class[]{JSONArray.class};
            }
        }
        throw new IllegalStateException("Unhandled JSON data type: " + (Object)((Object)this.m_DataType));
    }

    @Override
    protected String doExecute() {
        String result = null;
        JSONObject json = null;
        if (!(this.m_InputToken.getPayload() instanceof JSONObject)) {
            result = "Input is not of type " + JSONObject.class.getName() + "!";
        } else {
            json = (JSONObject)this.m_InputToken.getPayload();
        }
        if (result == null) {
            if (json.containsKey((Object)this.m_Key)) {
                Object val = json.get((Object)this.m_Key);
                if (this.isDebugOn()) {
                    this.debug("Found value for '" + this.m_Key + "': " + val);
                }
                if (val instanceof Number) {
                    val = new Double(((Number)val).doubleValue());
                }
                this.m_OutputToken = new Token(val);
            } else if (this.isDebugOn()) {
                this.debug("No value found for '" + this.m_Key + "'!");
            }
        }
        return result;
    }
}

