/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.Hashtable;

public class GlobalTransformer
extends AbstractGlobalActor
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = -4898610818562897692L;
    public static final String BACKUP_INPUT = "input";
    protected transient Token m_InputToken;

    @Override
    public String globalInfo() {
        return "Feeds tokens into a global transformer and broadcasts the generated output tokens.";
    }

    @Override
    protected AbstractActor findGlobalActor() {
        AbstractActor result = super.findGlobalActor();
        if (result != null && !ActorUtils.isTransformer(result)) {
            this.getSystemErr().println("Global actor '" + result.getFullName() + "' is not a transformer!");
            result = null;
        }
        return result;
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_INPUT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_INPUT, this.m_InputToken);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_INPUT)) {
            this.m_InputToken = (Token)state.get(BACKUP_INPUT);
            state.remove(BACKUP_INPUT);
        }
        super.restoreState(state);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_InputToken = null;
    }

    @Override
    public Class[] accepts() {
        if (this.m_GlobalActor != null) {
            return ((InputConsumer)((Object)this.m_GlobalActor)).accepts();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    public void input(Token token) {
        this.m_InputToken = token;
    }

    @Override
    public Class[] generates() {
        if (this.m_GlobalActor != null) {
            return ((OutputProducer)((Object)this.m_GlobalActor)).generates();
        }
        return new Class[]{Unknown.class};
    }

    @Override
    protected String executeGlobalActor() {
        if (this.m_InputToken != null) {
            ((InputConsumer)((Object)this.m_GlobalActor)).input(this.m_InputToken);
        }
        String result = this.m_GlobalActor.execute();
        return result;
    }

    @Override
    public Token output() {
        this.m_InputToken = null;
        return ((OutputProducer)((Object)this.m_GlobalActor)).output();
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_GlobalActor != null && ((OutputProducer)((Object)this.m_GlobalActor)).hasPendingOutput();
    }
}

