/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class IncVariable
extends AbstractTransformer {
    private static final long serialVersionUID = -8466653808821254082L;
    protected VariableName m_VariableName;
    protected IncrementType m_IncrementType;
    protected int m_IntegerIncrement;
    protected double m_DoubleIncrement;

    @Override
    public String globalInfo() {
        return "Increments the value of a variable by either an integer or double increment.\nIf the variable has not been set yet, it will get set to 0.\nIf the variable contains a non-numerical value, no increment will be performed.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("var-name", "variableName", new VariableName());
        this.m_OptionManager.add("inc-type", "incrementType", (Object)IncrementType.INTEGER);
        this.m_OptionManager.add("inc-int", "integerIncrement", 1);
        this.m_OptionManager.add("inc-double", "doubleIncrement", 1.0);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "variableName", this.m_VariableName.paddedValue());
        String variable = QuickInfoHelper.getVariable(this, "incrementType");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "incrementType", (Object)this.m_IncrementType, ", ");
        if (variable == null) {
            result = result + ", inc: ";
            switch (this.m_IncrementType) {
                case INTEGER: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, "integerIncrement", this.m_IntegerIncrement);
                    break;
                }
                case DOUBLE: {
                    result = result + QuickInfoHelper.toString((OptionHandler)this, "doubleIncrement", this.m_DoubleIncrement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                }
            }
        }
        return result;
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The name of the variable to increment.";
    }

    public void setIncrementType(IncrementType value) {
        this.m_IncrementType = value;
        this.reset();
    }

    public IncrementType getIncrementType() {
        return this.m_IncrementType;
    }

    public String incrementTypeTipText() {
        return "The type of increment to perform.";
    }

    public void setIntegerIncrement(int value) {
        this.m_IntegerIncrement = value;
        this.reset();
    }

    public int getIntegerIncrement() {
        return this.m_IntegerIncrement;
    }

    public String integerIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.INTEGER) + " increments.";
    }

    public void setDoubleIncrement(double value) {
        this.m_DoubleIncrement = value;
        this.reset();
    }

    public double getDoubleIncrement() {
        return this.m_DoubleIncrement;
    }

    public String doubleIncrementTipText() {
        return "The increment in case of " + (Object)((Object)IncrementType.DOUBLE) + " increments.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        Number value;
        String result = null;
        try {
            value = this.getVariables().has(this.m_VariableName.getValue()) ? new Double(this.getVariables().get(this.m_VariableName.getValue())) : new Double(0.0);
        }
        catch (Exception e) {
            value = null;
        }
        if (value != null) {
            switch (this.m_IncrementType) {
                case INTEGER: {
                    value = new Integer(((Number)value).intValue() + this.m_IntegerIncrement);
                    break;
                }
                case DOUBLE: {
                    value = new Double(value + this.m_DoubleIncrement);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled increment type: " + (Object)((Object)this.m_IncrementType));
                }
            }
            this.getVariables().set(this.m_VariableName.getValue(), "" + value);
            if (this.isDebugOn()) {
                this.debug("Incremented variable '" + this.m_VariableName + "': " + value);
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public static enum IncrementType {
        INTEGER,
        DOUBLE;

    }
}

