/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.json.simple.JSONAware;
import org.json.simple.parser.JSONParser;

public class JsonFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;

    @Override
    public String globalInfo() {
        return "Reads a JSON file and forwards the parsed JSON object.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{JSONAware.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file.getAbsolutePath()));
            JSONParser parser = new JSONParser();
            Object obj = parser.parse((Reader)reader);
            this.m_OutputToken = new Token(obj);
            reader.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to read JSON file: " + file, e);
        }
        return result;
    }
}

