/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class ReportField
extends AbstractTransformer {
    private static final long serialVersionUID = -2833759108269704357L;
    public static final String BACKUP_FIELDS = "fields";
    protected BaseRegExp m_RegExp;
    protected boolean m_OutputNameOnly;
    protected Vector<AbstractField> m_Fields;

    @Override
    public String globalInfo() {
        return "Returns all the fields in a report or the report from a report handling object that match the provided regular expression.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("output-name-only", "outputNameOnly", false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Fields = new Vector();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Fields.clear();
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_FIELDS);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        result.put(BACKUP_FIELDS, this.m_Fields);
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_FIELDS)) {
            this.m_Fields = (Vector)state.get(BACKUP_FIELDS);
            state.remove(BACKUP_FIELDS);
        }
        super.restoreState(state);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp);
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "outputNameOnly", this.m_OutputNameOnly ? "name only" : "name + type", "recursive"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the field names against.";
    }

    public void setOutputNameOnly(boolean value) {
        this.m_OutputNameOnly = value;
        this.reset();
    }

    public boolean getOutputNameOnly() {
        return this.m_OutputNameOnly;
    }

    public String outputNameOnlyTipText() {
        return "If enabled, only the field name is output and not the data type as well.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            this.m_Fields.clear();
            Report report = this.m_InputToken.getPayload() instanceof Report ? (Report)this.m_InputToken.getPayload() : ((ReportHandler)this.m_InputToken.getPayload()).getReport();
            if (report != null) {
                Vector<AbstractField> fields = report.getFields();
                for (AbstractField field : fields) {
                    if (!this.m_RegExp.isMatch(field.getName())) continue;
                    this.m_Fields.add(field);
                }
                if (this.isDebugOn()) {
                    this.debug("Matching fields: " + this.m_Fields);
                }
            } else if (this.isDebugOn()) {
                this.debug("No report available: " + this.m_InputToken);
            }
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to get report field(s): " + this.m_RegExp, e);
        }
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_Fields.size() > 0;
    }

    @Override
    public Token output() {
        Token result = this.m_OutputNameOnly ? new Token(this.m_Fields.get(0).toString()) : new Token(this.m_Fields.get(0).toParseableString());
        this.m_Fields.remove(0);
        this.m_OutputToken = null;
        this.m_InputToken = null;
        return result;
    }
}

