/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.CloneHandler;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpressionText;

public class ReportMathExpression
extends AbstractTransformer
implements GrammarSupplier {
    private static final long serialVersionUID = -8477454145267616359L;
    protected MathematicalExpressionText m_Expression;
    protected Field m_Field;
    protected boolean m_OutputResult;

    @Override
    public String globalInfo() {
        return "Evaluates a mathematical expression based on report values.\nEither outputs the updated report or the report handler if that allows updating the report. The calculated value can be output by itself, if the 'outputResult' property is enabled.\nVariables are supported as well, e.g.: pow(X,@{exp}) with '@{exp}' being a variable available at execution time.\n\nThe following grammar is used for the expressions:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return new adams.parser.ReportMathExpression().getGrammar();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("expression", "expression", new MathematicalExpressionText("42"));
        this.m_OptionManager.add("field", "field", new Field("Blah", DataType.NUMERIC));
        this.m_OptionManager.add("output-result", "outputResult", false);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "expression", this.m_Expression);
        if (QuickInfoHelper.hasVariable(this, "outputResult") || !this.m_OutputResult) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, "field", this.m_Field, ", field: ");
        }
        return result;
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The mathematical expression to evaluate.";
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field in the report to update.";
    }

    public void setOutputResult(boolean value) {
        this.m_OutputResult = value;
        this.reset();
    }

    public boolean getOutputResult() {
        return this.m_OutputResult;
    }

    public String outputResultTipText() {
        return "If enabled, then the result is output instead of the report field updated.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    @Override
    public Class[] generates() {
        if (this.m_OutputResult) {
            return new Class[]{Double.class};
        }
        return new Class[]{Report.class, ReportHandler.class};
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (this.m_Expression == null || this.m_Expression.getValue().length() == 0)) {
            result = "No expression provided!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        String result = null;
        String exp = this.m_Expression.getValue();
        try {
            Report report;
            ReportHandler handler;
            if (this.m_InputToken.getPayload() instanceof ReportHandler) {
                handler = (ReportHandler)this.m_InputToken.getPayload();
                report = handler.getReport();
            } else {
                handler = null;
                report = (Report)this.m_InputToken.getPayload();
            }
            exp = this.getVariables().expand(exp);
            Double eval = adams.parser.ReportMathExpression.evaluate(exp, report);
            if (this.m_OutputResult) {
                this.m_OutputToken = new Token(eval);
            } else {
                report = report.getClone();
                report.setValue(this.m_Field, eval);
                if (handler != null && handler instanceof MutableReportHandler) {
                    handler = handler instanceof CloneHandler ? (ReportHandler)((CloneHandler)((Object)handler)).getClone() : (ReportHandler)Utils.deepCopy(handler);
                    ((MutableReportHandler)handler).setReport(report);
                    this.m_OutputToken = new Token(handler);
                } else {
                    this.m_OutputToken = new Token(report);
                }
            }
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Error evaluating: " + exp, e);
        }
        return result;
    }
}

