/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;

public class SetStorageValue
extends AbstractTransformer {
    private static final long serialVersionUID = 3086015634110488066L;
    protected String m_Cache;
    protected StorageName m_StorageName;

    @Override
    public String globalInfo() {
        return "Stores the payload of the token passing through under the specified name in temporary storage.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("cache", "cache", "");
        this.m_OptionManager.add("storage-name", "storageName", new StorageName());
    }

    public void setCache(String value) {
        this.m_Cache = value;
        this.reset();
    }

    public String getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The name of the cache to store the value in; uses the regular storage if left empty.";
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored value to retrieve.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "storageName", this.m_StorageName);
        String value = QuickInfoHelper.toString((OptionHandler)this, "cache", this.m_Cache.length() > 0 ? this.m_Cache : "", " cache: ");
        if (value != null) {
            result = result + value;
        }
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String performSetUpChecks(boolean fromSetUp) {
        String result = super.performSetUpChecks(fromSetUp);
        if (result == null && this.canPerformSetUpCheck(fromSetUp, "storageName") && (this.m_StorageName == null || this.m_StorageName.getValue().length() == 0)) {
            result = "No name specified for storing value!";
        }
        return result;
    }

    @Override
    protected String doExecute() {
        if (this.m_InputToken.getPayload() != null) {
            if (this.m_Cache.length() == 0) {
                this.getStorageHandler().getStorage().put(this.m_StorageName, this.m_InputToken.getPayload());
            } else {
                this.getStorageHandler().getStorage().put(this.m_Cache, this.m_StorageName, this.m_InputToken.getPayload());
            }
        }
        this.m_OutputToken = this.m_InputToken;
        return null;
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }
}

