/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.DateTime;
import adams.core.EnumHelper;
import adams.core.Properties;
import adams.core.Time;
import adams.core.Utils;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.application.PreferenceType;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.chooser.ColorChooserPanel;
import adams.gui.chooser.DateChooserPanel;
import adams.gui.chooser.DateTimeChooserPanel;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.chooser.FileChooserPanel;
import adams.gui.chooser.FontChooserPanel;
import adams.gui.chooser.TimeChooserPanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ParameterPanel;
import adams.gui.goe.FontEditor;
import adams.gui.goe.GenericArrayEditorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTextField;

public abstract class AbstractPropertiesPreferencesPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -822178750857036833L;
    public static final int DEFAULT_WIDTH_CHOOSERS = 250;
    protected ParameterPanel m_PanelPreferences;
    protected Vector<String> m_Identifiers;
    protected Hashtable<String, PreferenceType> m_PreferenceTypes;
    protected Hashtable<String, PreferenceType> m_ActualPreferenceTypes;
    protected Hashtable<String, AbstractChooserPanel> m_Choosers;
    protected Hashtable<String, Class> m_Enums;
    protected Hashtable<String, String[]> m_Lists;
    protected Hashtable<String, String> m_Help;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Identifiers = new Vector();
        this.m_PreferenceTypes = new Hashtable();
        this.m_ActualPreferenceTypes = new Hashtable();
        this.m_Choosers = new Hashtable();
        this.m_Enums = new Hashtable();
        this.m_Lists = new Hashtable();
        this.m_Help = new Hashtable();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelPreferences = new ParameterPanel();
        this.add((Component)new BaseScrollPane(this.m_PanelPreferences), "Center");
    }

    @Override
    public abstract String getTitle();

    @Override
    public abstract String activate();

    public void clearPreferenceTypes() {
        this.m_PreferenceTypes.clear();
        this.m_ActualPreferenceTypes.clear();
        this.m_Choosers.clear();
        this.m_Enums.clear();
        this.m_Lists.clear();
        this.m_Help.clear();
    }

    protected void clearPreferences() {
        this.m_Identifiers.clear();
        this.m_PanelPreferences.clearParameters();
    }

    public void addPreference(String identifier, String label, Component comp) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelPreferences.addParameter(label, comp);
    }

    public void addPreference(String identifier, String label, AbstractChooserPanel chooser) {
        if (this.m_Identifiers.contains(identifier)) {
            throw new IllegalArgumentException("Identifier '" + identifier + "' already present!");
        }
        this.m_Identifiers.add(identifier);
        this.m_PanelPreferences.addParameter(label, (Component)chooser);
    }

    public Component getPreference(int index) {
        return this.m_PanelPreferences.getParameter(index);
    }

    public Component getPreference(String identifier) {
        int index = this.m_Identifiers.indexOf(identifier);
        if (index == -1) {
            return null;
        }
        return this.m_PanelPreferences.getParameter(index);
    }

    public int getPreferenceCount() {
        return this.m_PanelPreferences.getParameterCount();
    }

    public void addPreferenceType(String property, PreferenceType type) {
        this.m_PreferenceTypes.put(property, type);
    }

    public boolean hasPreferenceType(String property) {
        return this.m_PreferenceTypes.containsKey(property);
    }

    public PreferenceType getPreferenceType(String property) {
        if (this.hasPreferenceType(property)) {
            return this.m_PreferenceTypes.get(property);
        }
        return PreferenceType.STRING;
    }

    public PreferenceType getActualPreferenceType(String property) {
        if (this.m_ActualPreferenceTypes.containsKey(property)) {
            return this.m_ActualPreferenceTypes.get(property);
        }
        return PreferenceType.STRING;
    }

    public boolean hasChooser(String property) {
        return this.m_Choosers.containsKey(property);
    }

    public void setChooser(String property, AbstractChooserPanel value) {
        this.m_Choosers.put(property, value);
    }

    public AbstractChooserPanel getChooser(String property) {
        return this.m_Choosers.get(property);
    }

    public boolean hasEnum(String property) {
        return this.m_Enums.containsKey(property);
    }

    public void setEnum(String property, Class value) {
        this.m_Enums.put(property, value);
    }

    public Class getEnum(String property) {
        return this.m_Enums.get(property);
    }

    public boolean hasList(String property) {
        return this.m_Lists.containsKey(property);
    }

    public void setList(String property, String[] value) {
        this.m_Lists.put(property, value);
    }

    public String[] getList(String property) {
        return this.m_Lists.get(property);
    }

    public boolean hasHelp(String property) {
        return this.m_Help.containsKey(property);
    }

    public void setHelp(String property, String value) {
        this.m_Help.put(property, value);
    }

    public String getHelp(String property) {
        return this.m_Help.get(property);
    }

    public void setPreferences(Properties value) {
        this.clearPreferences();
        Vector<String> keys = new Vector<String>(value.keySetAll());
        Collections.sort(keys);
        block18: for (String key : keys) {
            PreferenceType type = this.getPreferenceType(key);
            String help = this.getHelp(key);
            if (type == PreferenceType.OBJECT_EDITOR) {
                if (!this.hasChooser(key)) {
                    type = PreferenceType.STRING;
                }
            } else if (type == PreferenceType.ENUM) {
                if (!this.hasEnum(key)) {
                    type = PreferenceType.STRING;
                }
            } else if (type == PreferenceType.LIST && !this.hasList(key)) {
                type = PreferenceType.STRING;
            }
            this.m_ActualPreferenceTypes.put(key, type);
            switch (type) {
                case TIME: {
                    TimeChooserPanel timePanel = new TimeChooserPanel();
                    timePanel.setCurrent(value.getTime(key));
                    timePanel.setToolTipText(help);
                    this.addPreference(key, key, timePanel);
                    continue block18;
                }
                case DATE: {
                    DateChooserPanel datePanel = new DateChooserPanel();
                    datePanel.setCurrent(value.getDate(key));
                    datePanel.setToolTipText(help);
                    this.addPreference(key, key, datePanel);
                    continue block18;
                }
                case DATETIME: {
                    DateTimeChooserPanel dateTimePanel = new DateTimeChooserPanel();
                    dateTimePanel.setCurrent(value.getDateTime(key));
                    dateTimePanel.setToolTipText(help);
                    this.addPreference(key, key, dateTimePanel);
                    continue block18;
                }
                case DOUBLE: 
                case STRING: {
                    JTextField textfield = new JTextField(20);
                    textfield.setText(value.getProperty(key));
                    textfield.setToolTipText(help);
                    this.addPreference(key, key, textfield);
                    continue block18;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = new JCheckBox();
                    checkbox.setSelected(value.getBoolean(key));
                    checkbox.setToolTipText(help);
                    this.addPreference(key, key, checkbox);
                    continue block18;
                }
                case INTEGER: {
                    JSpinner spinner = new JSpinner();
                    spinner.setValue(value.getInteger(key));
                    spinner.setToolTipText(help);
                    this.addPreference(key, key, spinner);
                    continue block18;
                }
                case FONT: {
                    FontChooserPanel fontPanel = new FontChooserPanel();
                    fontPanel.setCurrent((Font)FontEditor.valueOf(null, value.getProperty(key)));
                    fontPanel.setToolTipText(help);
                    this.addPreference(key, key, fontPanel);
                    continue block18;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = new DirectoryChooserPanel();
                    dirPanel.setCurrent(new PlaceholderDirectory(value.getString(key)));
                    dirPanel.setPreferredSize(new Dimension(250, dirPanel.getPreferredSize().height));
                    dirPanel.setToolTipText(help);
                    this.addPreference(key, key, dirPanel);
                    continue block18;
                }
                case FILE: {
                    FileChooserPanel filePanel = new FileChooserPanel();
                    filePanel.setCurrent(new PlaceholderFile(value.getString(key)));
                    filePanel.setPreferredSize(new Dimension(250, filePanel.getPreferredSize().height));
                    filePanel.setToolTipText(help);
                    this.addPreference(key, key, filePanel);
                    continue block18;
                }
                case COLOR: {
                    ColorChooserPanel colorPanel = new ColorChooserPanel();
                    colorPanel.setCurrent(value.getColor(key));
                    colorPanel.setToolTipText(help);
                    this.addPreference(key, key, colorPanel);
                    continue block18;
                }
                case ENUM: {
                    JComboBox<Object> combo = new JComboBox<Object>(EnumHelper.getValues(this.getEnum(key)));
                    combo.setSelectedItem(EnumHelper.parse(this.getEnum(key), value.getProperty(key)));
                    combo.setToolTipText(help);
                    this.addPreference(key, key, combo);
                    continue block18;
                }
                case LIST: {
                    JComboBox<Object> combo = new JComboBox<String>(this.getList(key));
                    combo.setSelectedItem(value.getProperty(key));
                    combo.setToolTipText(help);
                    this.addPreference(key, key, combo);
                    continue block18;
                }
                case BLANK_SEPARATED_LIST: 
                case COMMA_SEPARATED_LIST: {
                    AbstractChooserPanel chooserPanel = new GenericArrayEditorPanel(new BaseString[0]);
                    chooserPanel.setPreferredSize(new Dimension(250, chooserPanel.getPreferredSize().height));
                    String[] parts = type == PreferenceType.BLANK_SEPARATED_LIST ? value.getProperty(key).split(" ") : value.getProperty(key).split(",");
                    BaseString[] list = new BaseString[parts.length];
                    for (int i = 0; i < parts.length; ++i) {
                        list[i] = new BaseString(parts[i]);
                    }
                    chooserPanel.setCurrent(list);
                    this.addPreference(key, key, chooserPanel);
                    continue block18;
                }
                case OBJECT_EDITOR: {
                    AbstractChooserPanel chooserPanel = this.getChooser(key);
                    chooserPanel.setPreferredSize(new Dimension(250, chooserPanel.getPreferredSize().height));
                    chooserPanel.setToolTipText(help);
                    try {
                        chooserPanel.setCurrent(OptionUtils.forAnyCommandLine(Object.class, value.getProperty(key)));
                    }
                    catch (Exception e) {
                        System.err.println("Failed to instantiate: " + value.getProperty(key));
                        e.printStackTrace();
                    }
                    this.addPreference(key, key, chooserPanel);
                    continue block18;
                }
            }
            throw new IllegalStateException("Unhandled preference type (property '" + keys + "'): " + (Object)((Object)type));
        }
    }

    public Properties getPreferences() {
        Properties result = new Properties();
        block16: for (int i = 0; i < this.getPreferenceCount(); ++i) {
            Component comp = this.getPreference(i);
            String key = this.m_Identifiers.get(i);
            PreferenceType type = this.getActualPreferenceType(key);
            switch (type) {
                case TIME: {
                    TimeChooserPanel timePanel = (TimeChooserPanel)comp;
                    result.setTime(key, (Time)timePanel.getCurrent());
                    continue block16;
                }
                case DATE: {
                    DateChooserPanel datePanel = (DateChooserPanel)comp;
                    result.setDate(key, (Date)datePanel.getCurrent());
                    continue block16;
                }
                case DATETIME: {
                    DateTimeChooserPanel dateTimePanel = (DateTimeChooserPanel)comp;
                    result.setDateTime(key, (DateTime)dateTimePanel.getCurrent());
                    continue block16;
                }
                case DOUBLE: 
                case STRING: {
                    JTextField textfield = (JTextField)comp;
                    result.setProperty(key, textfield.getText());
                    continue block16;
                }
                case BOOLEAN: {
                    JCheckBox checkbox = (JCheckBox)comp;
                    result.setBoolean(key, checkbox.isSelected());
                    continue block16;
                }
                case INTEGER: {
                    JSpinner spinner = (JSpinner)comp;
                    result.setInteger(key, ((Number)spinner.getValue()).intValue());
                    continue block16;
                }
                case FONT: {
                    FontChooserPanel fontPanel = (FontChooserPanel)comp;
                    result.setProperty(key, FontEditor.toString(null, fontPanel.getCurrent()));
                    continue block16;
                }
                case DIRECTORY: {
                    DirectoryChooserPanel dirPanel = (DirectoryChooserPanel)comp;
                    result.setProperty(key, ((File)dirPanel.getCurrent()).getAbsolutePath());
                    continue block16;
                }
                case FILE: {
                    FileChooserPanel filePanel = (FileChooserPanel)comp;
                    result.setProperty(key, ((File)filePanel.getCurrent()).getAbsolutePath());
                    continue block16;
                }
                case COLOR: {
                    ColorChooserPanel colorPanel = (ColorChooserPanel)comp;
                    result.setColor(key, (Color)colorPanel.getCurrent());
                    continue block16;
                }
                case ENUM: {
                    JComboBox comboEnum = (JComboBox)comp;
                    if (comboEnum.getSelectedIndex() <= -1) continue block16;
                    result.setProperty(key, "" + comboEnum.getSelectedItem());
                    continue block16;
                }
                case LIST: {
                    JComboBox comboEnum = (JComboBox)comp;
                    if (comboEnum.getSelectedIndex() <= -1) continue block16;
                    result.setProperty(key, "" + comboEnum.getSelectedItem());
                    continue block16;
                }
                case BLANK_SEPARATED_LIST: 
                case COMMA_SEPARATED_LIST: {
                    AbstractChooserPanel chooserPanel = (AbstractChooserPanel)comp;
                    Object[] list = (BaseString[])chooserPanel.getCurrent();
                    if (type == PreferenceType.BLANK_SEPARATED_LIST) {
                        result.setProperty(key, Utils.flatten(list, " "));
                        continue block16;
                    }
                    result.setProperty(key, Utils.flatten(list, ","));
                    continue block16;
                }
                case OBJECT_EDITOR: {
                    AbstractChooserPanel chooserPanel = (AbstractChooserPanel)comp;
                    result.setProperty(key, OptionUtils.getCommandLine(chooserPanel.getCurrent()));
                    continue block16;
                }
                default: {
                    throw new IllegalStateException("Unhandled preference type (property '" + key + "'): " + (Object)((Object)type));
                }
            }
        }
        return result;
    }
}

