/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.application.PreferencesPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class PreferencesManagerPanel
extends BasePanel {
    private static final long serialVersionUID = 8245611221697036772L;
    protected BaseTabbedPane m_TabbedPane;
    protected ArrayList<PreferencesPanel> m_Panels;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Panels = new ArrayList();
    }

    @Override
    protected void initGUI() {
        String[] classes;
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        for (String cls : classes = AbstractPreferencesPanel.getPanels()) {
            try {
                this.m_Panels.add((PreferencesPanel)Class.forName(cls).newInstance());
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate preferences panel: " + cls);
                e.printStackTrace();
            }
        }
        Collections.sort(this.m_Panels);
        for (PreferencesPanel panel : this.m_Panels) {
            if (panel.requiresWrapper()) {
                JPanel wrapper = new JPanel(new BorderLayout());
                wrapper.add((Component)new BaseScrollPane((JComponent)((Object)panel)), "North");
                this.m_TabbedPane.addTab(panel.getTitle(), wrapper);
                continue;
            }
            this.m_TabbedPane.addTab(panel.getTitle(), (JComponent)((Object)panel));
        }
    }

    public void activate() {
        for (PreferencesPanel panel : this.m_Panels) {
            String msg = panel.activate();
            if (msg == null) continue;
            GUIHelper.showErrorMessage(this, msg);
        }
        GUIHelper.showInformationMessage(this, "For the changes to take effect, you need to restart the application now.");
    }
}

