/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.chooser;

import adams.core.Placeholders;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import com.googlecode.vfsjfilechooser2.filechooser.AbstractVFSFileFilter;
import com.googlecode.vfsjfilechooser2.plaf.metal.MetalVFSFileChooserUI;
import com.googlecode.vfsjfilechooser2.utils.FileObjectConverter;
import com.googlecode.vfsjfilechooser2.utils.VFSUtils;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import org.apache.commons.vfs2.FileObject;

public class BaseFileChooser
extends VFSJFileChooser {
    private static final long serialVersionUID = -5712455182900852653L;
    protected boolean m_PromptOverwriteFile;
    protected boolean m_AutoAppendExtension;
    protected boolean m_AllowGlobFilters;
    protected String m_DefaultExtension;

    public BaseFileChooser() {
        this.initialize();
    }

    public BaseFileChooser(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.initialize();
    }

    public BaseFileChooser(File currentDirectory) {
        super(VFSUtils.toFileObject((File)currentDirectory));
        this.initialize();
    }

    protected void initialize() {
        this.m_PromptOverwriteFile = true;
        this.m_AutoAppendExtension = false;
        this.m_AllowGlobFilters = true;
        this.m_DefaultExtension = null;
        this.setFileObjectConverter(new PlaceholderFileConverter());
        this.setFileHidingEnabled(false);
    }

    protected MetalVFSFileChooserUI createDefaultUI() {
        return new BaseVFSFileChooserUI(this);
    }

    public void setPromptOverwriteFile(boolean value) {
        this.m_PromptOverwriteFile = value;
    }

    public boolean getPromptOverwriteFile() {
        return this.m_PromptOverwriteFile;
    }

    public void setAutoAppendExtension(boolean value) {
        this.m_AutoAppendExtension = value;
    }

    public boolean getAutoAppendExtension() {
        return this.m_AutoAppendExtension;
    }

    public void setDefaultExtension(String value) {
        this.m_DefaultExtension = value;
    }

    public String getDefaultExtension() {
        return this.m_DefaultExtension;
    }

    public void setAllowGlobFilters(boolean value) {
        this.m_AllowGlobFilters = value;
    }

    public boolean getAllowGlobFilters() {
        return this.m_AllowGlobFilters;
    }

    protected boolean isGlobFilter(AbstractVFSFileFilter filter) {
        return filter.getClass().getName().endsWith("$GlobFilter");
    }

    public void addChoosableFileFilter(AbstractVFSFileFilter filter) {
        boolean ok;
        boolean bl = ok = filter instanceof ExtensionFileFilter || filter == this.getAcceptAllFileFilter() || this.isGlobFilter(filter) && this.getAllowGlobFilters();
        if (!ok) {
            if (this.isGlobFilter(filter)) {
                throw new IllegalArgumentException("Please select a filter from the drop-down list!");
            }
            throw new IllegalArgumentException("Only instances of " + ExtensionFileFilter.class.getName() + " are accepted!\n" + "Provided: " + filter.getClass().getName());
        }
        super.addChoosableFileFilter(filter);
    }

    public void setSelectedFile(File file) {
        File selFile = null;
        if (file != null) {
            selFile = new File(file.getAbsolutePath());
        }
        if (selFile == null) {
            return;
        }
        super.setSelectedFileObject(VFSUtils.toFileObject(selFile));
    }

    public PlaceholderFile getSelectedPlaceholderFile() {
        File file = super.getSelectedFile();
        if (file != null) {
            return new PlaceholderFile(file);
        }
        return null;
    }

    public void setSelectedFiles(File[] selectedFiles) {
        File[] files = null;
        if (selectedFiles != null) {
            files = new File[selectedFiles.length];
            for (int i = 0; i < selectedFiles.length; ++i) {
                files[i] = selectedFiles[i].getAbsoluteFile();
            }
        }
        super.setSelectedFiles(files);
    }

    public PlaceholderFile[] getSelectedPlaceholderFiles() {
        File[] files = super.getSelectedFiles();
        PlaceholderFile[] result = new PlaceholderFile[files.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new PlaceholderFile(files[i]);
        }
        return result;
    }

    protected boolean hasCorrectExtension(File file, String[] extensions) {
        boolean result = false;
        if (this.getDialogType() == VFSJFileChooser.DIALOG_TYPE.OPEN) {
            result = file.exists();
        }
        if (this.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE && this.getFileFilter() == this.getAcceptAllFileFilter()) {
            result = true;
        }
        if (this.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE && this.isGlobFilter(this.getFileFilter())) {
            result = true;
        }
        if (!result) {
            String filename = file.getAbsolutePath().toLowerCase();
            for (int i = 0; i < extensions.length; ++i) {
                if (!filename.endsWith("." + extensions[i].toLowerCase())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public VFSJFileChooser.RETURN_TYPE showDialog(Component parent, String approveButtonText) {
        VFSJFileChooser.RETURN_TYPE result = super.showDialog(parent, approveButtonText);
        if (this.m_AutoAppendExtension) {
            String[] extensions = null;
            extensions = this.getFileFilter() != this.getAcceptAllFileFilter() && !this.isGlobFilter(this.getFileFilter()) ? ((ExtensionFileFilter)this.getFileFilter()).getExtensions() : new String[]{this.getDefaultExtension()};
            if (extensions != null) {
                if (this.isMultiSelectionEnabled()) {
                    File[] selfiles = this.getSelectedFiles();
                    for (int i = 0; i < selfiles.length; ++i) {
                        if (this.hasCorrectExtension(selfiles[i], extensions)) continue;
                        selfiles[i] = new File(selfiles[i].getAbsolutePath() + "." + extensions[0]);
                    }
                    this.setSelectedFiles(selfiles);
                } else {
                    File selfile = this.getSelectedFile();
                    if (selfile != null) {
                        if (!this.hasCorrectExtension(selfile, extensions)) {
                            selfile = new File(selfile.getAbsolutePath() + "." + extensions[0]);
                        }
                        this.setSelectedFile(selfile);
                    }
                }
            }
        }
        if (result == VFSJFileChooser.RETURN_TYPE.APPROVE && this.getDialogType() == VFSJFileChooser.DIALOG_TYPE.SAVE && (this.getFileSelectionMode() == VFSJFileChooser.SELECTION_MODE.FILES_AND_DIRECTORIES || this.getFileSelectionMode() == VFSJFileChooser.SELECTION_MODE.FILES_ONLY) && this.getPromptOverwriteFile() && this.getSelectedFile() != null && this.getSelectedFile().exists() && !this.getSelectedFile().isDirectory()) {
            int retVal = GUIHelper.showConfirmMessage(parent, "File already exists - overwrite?\n" + this.getSelectedFile(), "File exists already");
            switch (retVal) {
                case 0: {
                    break;
                }
                case 1: {
                    result = this.showSaveDialog(parent);
                    break;
                }
                case 2: {
                    result = VFSJFileChooser.RETURN_TYPE.CANCEL;
                }
            }
        }
        return result;
    }

    public PlaceholderDirectory getCurrentPlaceholderDirectory() {
        File current = super.getCurrentDirectory();
        if (current == null) {
            return null;
        }
        return new PlaceholderDirectory(current);
    }

    public void setCurrentDirectory(File dir) {
        if (dir == null) {
            super.setCurrentDirectoryObject(null);
        } else {
            super.setCurrentDirectoryObject(VFSUtils.toFileObject((File)dir.getAbsoluteFile()));
        }
    }

    public static class BaseVFSFileChooserUI
    extends MetalVFSFileChooserUI {
        public BaseVFSFileChooserUI(VFSJFileChooser filechooser) {
            super(filechooser);
        }

        public String getFileName() {
            String result = super.getFileName();
            if (result != null) {
                result = Placeholders.expandStr(result);
            }
            return result;
        }
    }

    public static class PlaceholderFileConverter
    implements FileObjectConverter<PlaceholderFile> {
        public PlaceholderFile convertFileObject(FileObject file) {
            if (file == null) {
                return null;
            }
            try {
                if (file.getName().getBaseName().startsWith("${")) {
                    return new PlaceholderFile(file.getName().getBaseName());
                }
                return new PlaceholderFile(new URI(file.getName().getURI().replace(" ", "%20")));
            }
            catch (Exception e) {
                System.err.println("Failed to convert '" + file + "' into placeholder file!");
                e.printStackTrace();
                return null;
            }
        }
    }
}

