/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.StatusMessageHandler;
import adams.gui.core.BasePanel;
import adams.gui.core.MouseUtils;
import adams.gui.dialog.TextDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class BaseStatusBar
extends BasePanel
implements StatusMessageHandler {
    private static final long serialVersionUID = 4700122818727471957L;
    public static final String EMPTY_STATUS = " ";
    public static final String DEFAULT_TITLE = "Status";
    protected JLabel m_LabelStatus;
    protected MouseListener m_MouseListener;
    protected String m_StatusDialogTitle;
    protected StatusProcessor m_StatusProcessor;
    protected Dimension m_DialogSize;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_MouseListener = null;
        this.m_StatusDialogTitle = DEFAULT_TITLE;
        this.m_StatusProcessor = null;
        this.m_DialogSize = new Dimension(400, 300);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createBevelBorder(1));
        JPanel panel = new JPanel(new FlowLayout(2));
        this.m_LabelStatus = new JLabel(EMPTY_STATUS);
        panel.add((Component)this.m_LabelStatus, "West");
        this.add((Component)panel, "West");
    }

    protected void clearStatus() {
        this.m_LabelStatus.setText(EMPTY_STATUS);
    }

    public boolean hasStatus() {
        return !this.m_LabelStatus.getText().equals(EMPTY_STATUS);
    }

    public void setStatus(final String msg) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (msg == null || msg.length() == 0) {
                    BaseStatusBar.this.clearStatus();
                } else {
                    BaseStatusBar.this.m_LabelStatus.setText(msg);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String getStatus() {
        String result = null;
        if (!this.m_LabelStatus.getText().equals(EMPTY_STATUS)) {
            result = this.m_LabelStatus.getText();
        }
        return result;
    }

    @Override
    public void showStatus(String msg) {
        this.setStatus(msg);
    }

    protected void displayStatus() {
        TextDialog dialog;
        Window parent;
        String status = this.getStatus();
        if (this.m_StatusProcessor != null) {
            status = this.m_StatusProcessor.process(status);
        }
        if (this.getParentDialog() != null) {
            parent = this.getParentDialog();
            dialog = new TextDialog((Dialog)parent);
        } else {
            parent = this.getParentFrame();
            dialog = new TextDialog((Frame)parent);
        }
        dialog.setDialogTitle(this.m_StatusDialogTitle);
        dialog.setContent(status);
        dialog.setEditable(false);
        dialog.setSize(this.m_DialogSize);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.m_LabelStatus.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.m_LabelStatus.removeMouseListener(l);
    }

    public void setMouseListenerActive(boolean value) {
        if (value != (this.m_MouseListener != null)) {
            if (value) {
                this.m_MouseListener = new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (MouseUtils.isDoubleClick(e) && BaseStatusBar.this.m_LabelStatus.getText().length() > 0) {
                            e.consume();
                            BaseStatusBar.this.displayStatus();
                        } else if (MouseUtils.isRightClick(e)) {
                            e.consume();
                            JPopupMenu menu = BaseStatusBar.this.getPopup();
                            menu.show(BaseStatusBar.this.m_LabelStatus, e.getX(), e.getY());
                        } else {
                            super.mouseClicked(e);
                        }
                    }
                };
                this.addMouseListener(this.m_MouseListener);
            } else {
                this.removeMouseListener(this.m_MouseListener);
            }
        }
    }

    public boolean isMouseListenerActive() {
        return this.m_MouseListener != null;
    }

    protected JPopupMenu getPopup() {
        JPopupMenu result = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Show status");
        menuitem.setEnabled(this.m_LabelStatus.getText().length() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseStatusBar.this.displayStatus();
            }
        });
        result.add(menuitem);
        result.addSeparator();
        menuitem = new JMenuItem("Clear status");
        menuitem.setEnabled(this.m_LabelStatus.getText().length() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseStatusBar.this.clearStatus();
            }
        });
        result.add(menuitem);
        return result;
    }

    public void setStatusDialogTitle(String value) {
        this.m_StatusDialogTitle = value == null ? DEFAULT_TITLE : value;
    }

    public String getStatusDialogTitle() {
        return this.m_StatusDialogTitle;
    }

    public void setStatusProcessor(StatusProcessor value) {
        this.m_StatusProcessor = value;
    }

    public StatusProcessor getStatusProcessor() {
        return this.m_StatusProcessor;
    }

    public void setDialogSize(Dimension value) {
        this.m_DialogSize = new Dimension(value);
    }

    public Dimension getDialogSize() {
        return this.m_DialogSize;
    }

    public static interface StatusProcessor {
        public String process(String var1);
    }
}

