/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.core.Utils;
import adams.gui.core.CheckedTextField;
import javax.swing.text.Document;

public class NumberTextField
extends CheckedTextField {
    private static final long serialVersionUID = -2752548576627240791L;

    public NumberTextField(Type type) {
        super(new NumberCheckModel(type));
    }

    public NumberTextField(Type type, String text) {
        super(text, (CheckedTextField.AbstractCheckModel)new NumberCheckModel(type));
    }

    public NumberTextField(Type type, int columns) {
        super(columns, (CheckedTextField.AbstractCheckModel)new NumberCheckModel(type));
    }

    public NumberTextField(Type type, String text, int columns) {
        super(text, columns, new NumberCheckModel(type));
    }

    public NumberTextField(Type type, Document doc, String text, int columns) {
        super(doc, text, columns, new NumberCheckModel(type));
    }

    @Override
    protected CheckedTextField.AbstractCheckModel getDefaultCheckModel() {
        return new NumberCheckModel(Type.DOUBLE);
    }

    @Override
    public void setCheckModel(CheckedTextField.AbstractCheckModel value) {
        if (!(value instanceof NumberCheckModel)) {
            throw new IllegalArgumentException("Only " + NumberCheckModel.class.getName() + " models are allowed!");
        }
        super.setCheckModel(value);
    }

    public static class BoundedNumberCheckModel
    extends NumberCheckModel {
        private static final long serialVersionUID = -6009963184478082822L;
        protected Number m_LowerBound;
        protected Number m_UpperBound;

        public BoundedNumberCheckModel(Type type, Number lower, Number upper) {
            this(type, lower, upper, null);
        }

        public BoundedNumberCheckModel(Type type, Number lower, Number upper, Number defValue) {
            super(type, defValue);
            this.m_LowerBound = lower;
            this.m_UpperBound = upper;
        }

        @Override
        public boolean isValid(String text) {
            boolean result = super.isValid(text);
            if (result) {
                Double value = new Double(text);
                if (this.m_LowerBound != null && value < this.m_LowerBound.doubleValue()) {
                    result = false;
                }
                if (this.m_UpperBound != null && value > this.m_UpperBound.doubleValue()) {
                    result = false;
                }
            }
            return result;
        }

        public Number getLowerBound() {
            return this.m_LowerBound;
        }

        public Number getUpperBound() {
            return this.m_UpperBound;
        }

        @Override
        public String toString() {
            return super.toString() + ", lower=" + this.m_LowerBound + ", upper=" + this.m_UpperBound;
        }
    }

    public static class NumberCheckModel
    extends CheckedTextField.AbstractCheckModel {
        private static final long serialVersionUID = -6009963184478082822L;
        protected Type m_Type;

        public NumberCheckModel(Type type) {
            this(type, null);
        }

        public NumberCheckModel(Type type, Number defValue) {
            this.m_Type = type;
            if (defValue == null) {
                switch (this.m_Type) {
                    case BYTE: {
                        defValue = new Byte(0);
                        break;
                    }
                    case SHORT: {
                        defValue = new Short(0);
                        break;
                    }
                    case INTEGER: {
                        defValue = new Integer(0);
                        break;
                    }
                    case LONG: {
                        defValue = new Long(0L);
                        break;
                    }
                    case FLOAT: {
                        defValue = new Float(0.0);
                        break;
                    }
                    case DOUBLE: {
                        defValue = new Double(0.0);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled number type: " + (Object)((Object)this.m_Type));
                    }
                }
            }
            this.m_DefaultValue = defValue.toString();
        }

        @Override
        public boolean isValid(String text) {
            boolean result;
            if (text.trim().length() == 0) {
                return false;
            }
            try {
                switch (this.m_Type) {
                    case BYTE: {
                        Byte.parseByte(text);
                        break;
                    }
                    case SHORT: {
                        Short.parseShort(text);
                        break;
                    }
                    case INTEGER: {
                        Integer.parseInt(text);
                        break;
                    }
                    case LONG: {
                        Long.parseLong(text);
                        break;
                    }
                    case FLOAT: {
                        Utils.toFloat(text);
                        break;
                    }
                    case DOUBLE: {
                        Utils.toDouble(text);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unhandled number type: " + (Object)((Object)this.m_Type));
                    }
                }
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
            return result;
        }

        public Type getType() {
            return this.m_Type;
        }

        @Override
        public String toString() {
            return super.toString() + ", type=" + (Object)((Object)this.m_Type);
        }
    }

    public static enum Type {
        BYTE,
        SHORT,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

