/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextPane;

public class ParameterPanel
extends BasePanel {
    private static final long serialVersionUID = 7164103981772081436L;
    protected Vector<JLabel> m_Labels;
    protected Vector<Component> m_Parameters;
    protected int m_GapHorizontal;
    protected int m_GapVertical;
    protected Dimension m_PreferredDimensionJSpinner;

    public ParameterPanel() {
        this(0, 0);
    }

    public ParameterPanel(int hgap, int vgap) {
        this.m_GapHorizontal = hgap;
        this.m_GapVertical = vgap;
        this.update();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Labels = new Vector();
        this.m_Parameters = new Vector();
        this.m_PreferredDimensionJSpinner = new Dimension(100, 20);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.update();
    }

    public void clearParameters() {
        this.m_Labels.clear();
        this.m_Parameters.clear();
        this.update();
    }

    public void setPreferredDimensionJSpinner(Dimension value) {
        this.m_PreferredDimensionJSpinner = (Dimension)value.clone();
        this.update();
    }

    public Dimension getPreferredDimensionJSpinner() {
        return this.m_PreferredDimensionJSpinner;
    }

    public void addParameter(String label, Component comp) {
        this.addParameter(-1, label, comp);
    }

    public void addParameter(AbstractChooserPanel chooser) {
        this.addParameter(-1, chooser);
    }

    public void addParameter(int index, String label, Component comp) {
        JLabel lbl = new JLabel(label.replace("_", ""));
        lbl.setDisplayedMnemonic(GUIHelper.getMnemonic(label));
        lbl.setLabelFor(comp);
        if (comp instanceof JTextArea) {
            comp = new BaseScrollPane(comp);
        } else if (comp instanceof JTextPane) {
            comp = new BaseScrollPane(comp);
        }
        GridBagLayout gbL = new GridBagLayout();
        JPanel panel = new JPanel(gbL);
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints(lbl, gbC);
        panel.add(lbl);
        gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 1;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints(comp, gbC);
        panel.add(comp);
        if (index == -1) {
            this.m_Labels.add(lbl);
            this.m_Parameters.add(comp);
        } else {
            this.m_Labels.add(index, lbl);
            this.m_Parameters.add(index, comp);
        }
        this.update();
    }

    public void addParameter(int index, AbstractChooserPanel chooser) {
        GridBagLayout gbL = new GridBagLayout();
        JPanel panel = new JPanel(gbL);
        GridBagConstraints gbC = new GridBagConstraints();
        gbC.anchor = 17;
        gbC.fill = 2;
        gbC.gridy = 0;
        gbC.gridx = 0;
        gbC.weightx = 100.0;
        gbC.ipadx = 20;
        gbC.insets = new Insets(2, 5, 2, 5);
        gbL.setConstraints(chooser, gbC);
        panel.add(chooser);
        panel = new JPanel(new FlowLayout(0));
        panel.add(chooser);
        if (index == -1) {
            this.m_Labels.add(chooser.getPrefixLabel());
            this.m_Parameters.add(chooser);
        } else {
            this.m_Labels.add(index, chooser.getPrefixLabel());
            this.m_Parameters.add(index, chooser);
        }
        this.update();
    }

    public void removeParameter(int index) {
        this.m_Labels.remove(index);
        this.m_Parameters.remove(index);
        this.update();
    }

    public Component getParameter(int index) {
        return this.m_Parameters.get(index);
    }

    public int getParameterCount() {
        return this.m_Parameters.size();
    }

    public JLabel getLabel(int index) {
        return this.m_Labels.get(index);
    }

    protected void update() {
        GridBagConstraints con;
        int i;
        this.removeAll();
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        for (i = 0; i < this.m_Parameters.size(); ++i) {
            if (!(this.m_Parameters.get(i) instanceof JSpinner)) continue;
            ((JSpinner)this.m_Parameters.get(i)).setPreferredSize((Dimension)this.m_PreferredDimensionJSpinner.clone());
        }
        for (i = 0; i < this.m_Labels.size(); ++i) {
            con = new GridBagConstraints();
            con.anchor = 17;
            con.gridy = i;
            con.gridx = 0;
            con.insets = new Insets(3, 5, 3, 5);
            layout.setConstraints(this.m_Labels.get(i), con);
            this.add(this.m_Labels.get(i));
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 2;
            con.gridy = i;
            con.gridx = 1;
            con.weightx = 100.0;
            con.ipadx = 20;
            con.gridwidth = 0;
            con.insets = new Insets(3, 5, 3, 5);
            layout.setConstraints(this.m_Parameters.get(i), con);
            this.add(this.m_Parameters.get(i));
        }
        JPanel panel = new JPanel();
        con = new GridBagConstraints();
        con.anchor = 17;
        con.fill = 1;
        con.gridy = this.m_Labels.size();
        con.gridx = 0;
        con.weighty = 100.0;
        con.gridwidth = 0;
        layout.setConstraints(panel, con);
        this.add(panel);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.m_Parameters.size(); ++i) {
            this.m_Parameters.get(i).setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }
}

