/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetSupporter;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.MouseUtils;
import adams.gui.core.SortableAndSearchableTable;
import adams.gui.core.SpreadSheetCellRenderer;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SpreadSheetTable
extends SortableAndSearchableTable
implements SpreadSheetSupporter {
    private static final long serialVersionUID = 1333317577811620786L;
    protected PopupMenuCustomizer m_PopupMenuCustomizer;
    protected SpreadSheetFileChooser m_FileChooser;

    public SpreadSheetTable(SpreadSheet sheet) {
        this(new SpreadSheetTableModel(sheet));
    }

    public SpreadSheetTable(SpreadSheetTableModel model) {
        super(model);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_PopupMenuCustomizer = null;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    SpreadSheetTable.this.showPopupMenu(e);
                }
            }
        });
    }

    protected void setCustomCellRenderer() {
        SpreadSheetCellRenderer renderer = new SpreadSheetCellRenderer();
        TableColumnModel colModel = this.getColumnModel();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            colModel.getColumn(i).setCellRenderer(renderer);
        }
    }

    @Override
    public void setModel(TableModel model) {
        super.setModel(model);
        this.setCustomCellRenderer();
    }

    @Override
    protected boolean initialUseOptimalColumnWidths() {
        return true;
    }

    @Override
    protected boolean initialSortNewTableModel() {
        return false;
    }

    @Override
    protected Class getTableModelClass() {
        return SpreadSheetTableModel.class;
    }

    @Override
    protected TableModel createDefaultDataModel() {
        return new SpreadSheetTableModel();
    }

    public Cell getCellAt(int rowIndex, int columnIndex) {
        SpreadSheetTableModel sheetmodel = (SpreadSheetTableModel)this.getUnsortedModel();
        Cell result = sheetmodel.getCellAt(this.getActualRow(rowIndex), columnIndex);
        return result;
    }

    public void setNumDecimals(int value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNumDecimals(value);
    }

    public int getNumDecimals() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNumDecimals();
    }

    @Override
    public SpreadSheet toSpreadSheet() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).toSpreadSheet();
    }

    protected synchronized SpreadSheetFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
            this.m_FileChooser.setMultiSelectionEnabled(false);
        }
        return this.m_FileChooser;
    }

    protected void showPopupMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuitem = new JMenuItem("Copy");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(this.getSelectedRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetTable.this.copyToClipboard();
            }
        });
        menu.add(menuitem);
        menuitem = new JMenuItem("Save as...");
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VFSJFileChooser.RETURN_TYPE ret = SpreadSheetTable.this.getFileChooser().showSaveDialog(SpreadSheetTable.this);
                if (ret != VFSJFileChooser.RETURN_TYPE.APPROVE) {
                    return;
                }
                File file = SpreadSheetTable.this.getFileChooser().getSelectedFile();
                SpreadSheetWriter writer = SpreadSheetTable.this.getFileChooser().getWriter();
                if (!writer.write(SpreadSheetTable.this.toSpreadSheet(), file)) {
                    GUIHelper.showErrorMessage(SpreadSheetTable.this, "Failed to save spreadsheet to the following file:\n" + file);
                }
            }
        });
        menu.add(menuitem);
        menuitem = new JCheckBoxMenuItem("Show formulas");
        menuitem.setIcon(GUIHelper.getIcon("formula.png"));
        menuitem.setEnabled(this.getRowCount() > 0);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadSheetTable.this.setShowFormulas(!SpreadSheetTable.this.getShowFormulas());
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(e, menu);
        }
        menu.show(this, e.getX(), e.getY());
    }

    public void setPopupMenuCustomizer(PopupMenuCustomizer value) {
        this.m_PopupMenuCustomizer = value;
    }

    public PopupMenuCustomizer getPopupMenuCustomizer() {
        return this.m_PopupMenuCustomizer;
    }

    public boolean hasNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasNegativeBackground();
    }

    public void setNegativeBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setNegativeBackground(value);
    }

    public Color getNegativeBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getNegativeBackground();
    }

    public boolean hasPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).hasPositiveBackground();
    }

    public void setPositiveBackground(Color value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setPositiveBackground(value);
    }

    public Color getPositiveBackground() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getPositiveBackground();
    }

    public void setShowFormulas(boolean value) {
        ((SpreadSheetTableModel)this.getUnsortedModel()).setShowFormulas(value);
    }

    public boolean getShowFormulas() {
        return ((SpreadSheetTableModel)this.getUnsortedModel()).getShowFormulas();
    }

    public void sort(RowComparator comparator) {
        this.toSpreadSheet().sort(comparator);
        ((SpreadSheetTableModel)this.getUnsortedModel()).fireTableDataChanged();
    }
}

