/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tab;

import adams.core.option.AbstractOptionProducer;
import adams.core.option.NestedProducer;
import adams.flow.core.AbstractActor;
import adams.gui.core.BaseList;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.flow.FlowPanel;
import adams.gui.flow.tab.AbstractEditorTab;
import adams.gui.flow.tab.SelectionAwareEditorTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;

public class Clipboard
extends AbstractEditorTab
implements SelectionAwareEditorTab {
    private static final long serialVersionUID = 8054086756987403832L;
    protected BaseSplitPane m_SplitPane;
    protected BaseList m_ListItems;
    protected DefaultListModel m_ListItemsModel;
    protected FlowPanel m_PanelPreview;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonAdd;
    protected JButton m_ButtonRemove;
    protected JButton m_ButtonCopy;
    protected JPanel m_PanelButtons;

    @Override
    public String getTitle() {
        return "Clipboard";
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(0);
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(0.5);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_ListItemsModel = new DefaultListModel();
        this.m_ListItems = new BaseList((ListModel)this.m_ListItemsModel);
        this.m_ListItems.setSelectionMode(2);
        this.m_ListItems.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Clipboard.this.updateButtons();
                Clipboard.this.updatePreview();
            }
        });
        this.m_SplitPane.setTopComponent(new BaseScrollPane(this.m_ListItems));
        this.m_PanelPreview = new FlowPanel();
        this.m_PanelPreview.getTree().setEditable(false);
        this.m_SplitPane.setBottomComponent(this.m_PanelPreview);
        this.m_PanelButtons = new JPanel(new FlowLayout(0));
        this.add((Component)this.m_PanelButtons, "South");
        this.m_ButtonClear = new JButton(GUIHelper.getIcon("new.gif"));
        this.m_ButtonClear.setToolTipText("Remove all entries");
        this.m_ButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard.this.m_ListItemsModel.clear();
            }
        });
        this.m_PanelButtons.add(this.m_ButtonClear);
        this.m_ButtonAdd = new JButton(GUIHelper.getIcon("add.gif"));
        this.m_ButtonAdd.setToolTipText("Add currently selected actor to clipboard");
        this.m_ButtonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractActor actor = Clipboard.this.getCurrentPanel().getTree().getSelectedNode().getFullActor();
                String name = JOptionPane.showInputDialog(Clipboard.this.m_ListItems, "Please enter name for clipboard item:", actor.getName());
                if (name == null) {
                    return;
                }
                Clipboard.this.m_ListItemsModel.addElement(new ClipboardItem(name, actor));
            }
        });
        this.m_PanelButtons.add(this.m_ButtonAdd);
        this.m_ButtonRemove = new JButton(GUIHelper.getIcon("delete.gif"));
        this.m_ButtonRemove.setToolTipText("Remove selected entries");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = Clipboard.this.m_ListItems.getSelectedIndices();
                Arrays.sort(indices);
                for (int i = indices.length - 1; i >= 0; --i) {
                    Clipboard.this.m_ListItemsModel.removeElementAt(indices[i]);
                }
            }
        });
        this.m_PanelButtons.add(this.m_ButtonRemove);
        this.m_ButtonCopy = new JButton(GUIHelper.getIcon("copy.gif"));
        this.m_ButtonCopy.setToolTipText("Copy actor to system clipboard");
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClipboardItem item = (ClipboardItem)Clipboard.this.m_ListItems.getSelectedValue();
                GUIHelper.copyToClipboard(AbstractOptionProducer.toString(NestedProducer.class, item.getActor()));
            }
        });
        this.m_PanelButtons.add(this.m_ButtonCopy);
    }

    @Override
    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
        this.updatePreview();
    }

    @Override
    public void actorSelectionChanged(TreePath[] paths, AbstractActor[] actors) {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonClear.setEnabled(this.m_ListItemsModel.getSize() > 0);
        this.m_ButtonAdd.setEnabled(this.getCurrentPanel() != null && this.getCurrentPanel().getTree().getSelectionCount() == 1);
        this.m_ButtonRemove.setEnabled(this.m_ListItems.getSelectedIndices().length > 0);
        this.m_ButtonCopy.setEnabled(this.m_ListItems.getSelectedIndices().length == 1);
    }

    protected void updatePreview() {
        AbstractActor actor;
        if (this.m_ListItems.getSelectedIndex() == -1) {
            actor = null;
        } else {
            ClipboardItem item = (ClipboardItem)this.m_ListItems.getSelectedValue();
            actor = item.getActor();
        }
        this.m_PanelPreview.getTree().setActor(actor);
    }

    public static class ClipboardItem
    implements Serializable {
        private static final long serialVersionUID = 7449734120644203603L;
        protected String m_Name;
        protected AbstractActor m_Actor;

        public ClipboardItem(String name, AbstractActor actor) {
            this.m_Name = name;
            this.m_Actor = actor;
        }

        public void setName(String value) {
            this.m_Name = value;
        }

        public String getName() {
            return this.m_Name;
        }

        public AbstractActor getActor() {
            return this.m_Actor;
        }

        public String toString() {
            return this.m_Name;
        }
    }
}

