/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiSelectionEditor;
import adams.gui.goe.PropertyPanel;
import adams.gui.tools.PreviewBrowserPanel;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class FileEditor
extends AbstractPropertyEditorSupport
implements PropertyPanel.PopupMenuCustomizer,
CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected transient BaseFileChooser m_FileChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((File)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new File(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return FileEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return FileEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new java.io.File(\"" + f.getName() + "\")";
    }

    protected BaseFileChooser getFileChooser() {
        if (this.m_FileChooser == null) {
            File currentFile = (File)this.getValue();
            BaseFileChooser fileChooser = currentFile != null ? new BaseFileChooser() : new BaseFileChooser(new File(System.getProperty("user.dir")));
            fileChooser.setApproveButtonText("Select");
            fileChooser.setApproveButtonMnemonic('S');
            fileChooser.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_AND_DIRECTORIES);
            fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmdString = e.getActionCommand();
                    if (cmdString.equals("ApproveSelection")) {
                        File newVal = FileEditor.this.getFileChooser().getSelectedFile();
                        FileEditor.this.setValue(newVal);
                        FileEditor.this.closeDialog(1);
                    } else {
                        FileEditor.this.closeDialog(0);
                    }
                }
            });
            this.m_FileChooser = fileChooser;
        }
        return this.m_FileChooser;
    }

    @Override
    protected JComponent createCustomEditor() {
        return this.getFileChooser();
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        File currentFile = (File)this.getValue();
        if (currentFile != null) {
            this.getFileChooser().setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No file";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(new File(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((File)this.getValue()).toString();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        try {
            new File(value).getAbsolutePath();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        BaseFileChooser chooser = new BaseFileChooser(new PlaceholderFile(System.getProperty("user.dir")));
        chooser.setApproveButtonText("Select");
        chooser.setApproveButtonMnemonic('S');
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(VFSJFileChooser.SELECTION_MODE.FILES_AND_DIRECTORIES);
        VFSJFileChooser.RETURN_TYPE retVal = chooser.showOpenDialog(parent);
        Object[] result = retVal == VFSJFileChooser.RETURN_TYPE.APPROVE ? chooser.getSelectedFiles() : new File[]{};
        return result;
    }

    @Override
    public void customizePopupMenu(final BasePanel owner, JPopupMenu menu) {
        final PlaceholderFile file = (PlaceholderFile)this.getValue();
        JMenuItem menuitem = new JMenuItem("Open in preview browser...");
        menuitem.setIcon(GUIHelper.getIcon("open.gif"));
        menuitem.setEnabled(file.exists() && !file.isDirectory());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewBrowserPanel panel = new PreviewBrowserPanel();
                panel.open(file);
                BaseDialog dialog = owner.getParentDialog() != null ? new BaseDialog(owner.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(owner.getParentFrame(), true);
                dialog.setSize(800, 800);
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)panel, "Center");
                dialog.setJMenuBar(panel.getMenuBar());
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
        menuitem = new JMenuItem("Copy (absolute path)");
        menuitem.setIcon(GUIHelper.getIcon("copy.gif"));
        menuitem.setEnabled(true);
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GUIHelper.copyToClipboard(file.getAbsolutePath());
            }
        });
        menu.add(menuitem);
    }
}

