/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.gui.core.NumberTextField;
import adams.gui.goe.AbstractFloatingPointNumberEditor;

public class FloatEditor
extends AbstractFloatingPointNumberEditor {
    public FloatEditor() {
        this.m_CurrentValue = new Float(0.0f);
    }

    @Override
    protected NumberTextField.Type getType() {
        return NumberTextField.Type.FLOAT;
    }

    @Override
    public void setValue(Object value) {
        this.m_CurrentValue = new Float(((Number)value).floatValue());
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.m_CurrentValue;
    }

    @Override
    protected Object parse(String text) throws IllegalArgumentException {
        Float result;
        try {
            if (text.length() == 0) {
                text = "0";
            }
            result = Utils.toFloat(text);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return result;
    }
}

