/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.option.OptionUtils;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.event.HistorySelectionEvent;
import adams.gui.event.HistorySelectionListener;
import adams.gui.goe.Favorites;
import adams.gui.goe.GenericObjectEditor;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.goe.GenericObjectEditorPopupMenu;
import adams.gui.goe.ObjectHistory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GenericObjectEditorPanel
extends AbstractChooserPanel {
    private static final long serialVersionUID = -8351558686664299781L;
    protected GenericObjectEditor m_Editor;
    protected GenericObjectEditorDialog m_Dialog;
    protected ObjectHistory m_History;
    protected transient Object m_Current;

    public GenericObjectEditorPanel(Class cls, Object defValue) {
        this(cls, defValue, false);
    }

    public GenericObjectEditorPanel(Class cls, Object defValue, boolean canChangeClassInDialog) {
        this.m_Editor = new GenericObjectEditor(canChangeClassInDialog);
        this.m_Editor.setClassType(cls);
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericObjectEditorPanel.this.setCurrent(GenericObjectEditorPanel.this.m_Editor.getValue());
                GenericObjectEditorPanel.this.m_History.add(GenericObjectEditorPanel.this.m_Editor.getValue());
                GenericObjectEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericObjectEditorPanel.this.m_Self));
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_Editor.getCustomEditor()).addCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericObjectEditorPanel.this.m_Editor.setValue(GenericObjectEditorPanel.this.getCurrent());
            }
        });
        this.setCurrent(defValue);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Editor = null;
        this.m_History = new ObjectHistory();
        this.m_Current = null;
    }

    protected Object doChoose() {
        if (this.m_Current != null) {
            this.m_Editor.setValue(this.m_Current);
        }
        if (this.m_Dialog == null) {
            this.m_Dialog = GenericObjectEditorDialog.createDialog(this, this.m_Editor);
        }
        this.m_Dialog.setLocationRelativeTo(this);
        this.m_Dialog.setVisible(true);
        if (this.m_Dialog.getResult() == 0) {
            return this.m_Editor.getValue();
        }
        return null;
    }

    protected Object fromString(String value) {
        try {
            return OptionUtils.forAnyCommandLine(Object.class, value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getCurrent() {
        return Utils.deepCopy(this.m_Current);
    }

    protected String toString(Object value) {
        return OptionUtils.getCommandLine(value);
    }

    public boolean setCurrent(Object value) {
        boolean result = super.setCurrent(value);
        if (result) {
            this.m_Current = value;
            if (this.m_Current != null) {
                this.m_Editor.setValue(this.m_Current);
            }
        }
        return result;
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        GenericObjectEditorPopupMenu menu = new GenericObjectEditorPopupMenu(this.m_Editor, this.m_Self);
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GenericObjectEditorPanel.this.setCurrent(GenericObjectEditorPanel.this.m_Editor.getValue());
                GenericObjectEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericObjectEditorPanel.this.m_Self));
            }
        });
        JMenuItem item = new JMenuItem("Edit...", GUIHelper.getIcon("properties.gif"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenericObjectEditorPanel.this.choose();
            }
        });
        menu.insert(new JPopupMenu.Separator(), 0);
        menu.insert(item, 0);
        menu.addSeparator();
        Favorites.getSingleton().customizePopupMenu(menu, this.m_Editor.getClassType(), this.getCurrent(), new Favorites.FavoriteSelectionListener(){

            @Override
            public void favoriteSelected(Favorites.FavoriteSelectionEvent e) {
                GenericObjectEditorPanel.this.setCurrent(e.getFavorite().getObject());
                GenericObjectEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericObjectEditorPanel.this.m_Self));
            }
        });
        this.m_History.customizePopupMenu(menu, this.getCurrent(), new HistorySelectionListener(){

            @Override
            public void historySelected(HistorySelectionEvent e) {
                GenericObjectEditorPanel.this.setCurrent(e.getHistoryItem());
                GenericObjectEditorPanel.this.notifyChangeListeners(new ChangeEvent(GenericObjectEditorPanel.this.m_Self));
            }
        });
        if (this.m_PopupMenuCustomizer != null) {
            this.m_PopupMenuCustomizer.customizePopupMenu(this, (JPopupMenu)menu);
        }
        return menu;
    }
}

