/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractOption;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.PropertyPanel;
import adams.gui.tools.PreviewBrowserPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PlaceholderDirectoryEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport,
PropertyPanel.PopupMenuCustomizer {
    protected BaseDirectoryChooser m_DirChooser;

    public static String toString(AbstractOption option, Object object) {
        return ((PlaceholderDirectory)object).getPath();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new PlaceholderDirectory(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return PlaceholderDirectoryEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return PlaceholderDirectoryEditor.valueOf(null, str);
    }

    @Override
    public String getJavaInitializationString() {
        File f = (File)this.getValue();
        if (f == null) {
            return "null";
        }
        return "new adams.core.io.PlaceholderDirectory(\"" + f.getName() + "\")";
    }

    @Override
    protected JComponent createCustomEditor() {
        PlaceholderDirectory currentDir = (PlaceholderDirectory)this.getValue();
        this.m_DirChooser = currentDir != null ? new BaseDirectoryChooser() : new BaseDirectoryChooser(new File(System.getProperty("user.dir")));
        this.m_DirChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmdString = e.getActionCommand();
                if (cmdString.equals("ApproveSelection")) {
                    PlaceholderDirectory newVal = new PlaceholderDirectory(PlaceholderDirectoryEditor.this.m_DirChooser.getSelectedFile().getAbsolutePath());
                    PlaceholderDirectoryEditor.this.setValue(newVal);
                    PlaceholderDirectoryEditor.this.closeDialog(1);
                } else {
                    PlaceholderDirectoryEditor.this.closeDialog(0);
                }
            }
        });
        return this.m_DirChooser;
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        PlaceholderDirectory currentFile = (PlaceholderDirectory)this.getValue();
        if (currentFile != null) {
            this.m_DirChooser.setSelectedFile(currentFile);
        }
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        File f = (File)this.getValue();
        String val = "No directory";
        if (f != null) {
            val = f.getPath();
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isInlineValueValid(value)) {
            this.setValue(new PlaceholderDirectory(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((PlaceholderDirectory)this.getValue()).toString();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return PlaceholderDirectory.isValid(value);
    }

    @Override
    public void customizePopupMenu(final BasePanel owner, JPopupMenu menu) {
        final PlaceholderFile file = (PlaceholderFile)this.getValue();
        JMenuItem menuitem = new JMenuItem("Open in preview browser...");
        menuitem.setIcon(GUIHelper.getIcon("open.gif"));
        menuitem.setEnabled(file.exists() && !file.isDirectory());
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreviewBrowserPanel panel = new PreviewBrowserPanel();
                panel.open(file);
                BaseDialog dialog = owner.getParentDialog() != null ? new BaseDialog(owner.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new BaseDialog(owner.getParentFrame(), true);
                dialog.setSize(800, 800);
                dialog.getContentPane().setLayout(new BorderLayout());
                dialog.getContentPane().add((Component)panel, "Center");
                dialog.setJMenuBar(panel.getMenuBar());
                dialog.setLocationRelativeTo(dialog.getOwner());
                dialog.setVisible(true);
            }
        });
        menu.addSeparator();
        menu.add(menuitem);
    }
}

