/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Range;
import adams.core.Utils;
import adams.core.option.AbstractOption;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RangeEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor,
InlineEditorSupport {
    protected JTextField m_TextValue;
    protected JPanel m_PanelValue;
    protected Color m_DefaultBackground;

    public static String toString(AbstractOption option, Object object) {
        return ((Range)object).getRange();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new Range(str);
    }

    @Override
    public String toCustomStringRepresentation(Object obj) {
        return RangeEditor.toString(null, obj);
    }

    @Override
    public Object fromCustomStringRepresentation(String str) {
        return new Range(str);
    }

    @Override
    public String getJavaInitializationString() {
        return "new " + this.getValue().getClass().getName() + "(\"" + this.getValue() + "\")";
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getStringToPaint();
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected Range parse(String s) {
        Range result = null;
        if (s.length() == 0) {
            result = new Range();
        } else {
            try {
                if (Range.isValid(s, Integer.MAX_VALUE)) {
                    result = new Range(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        return result;
    }

    @Override
    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_PanelValue = new JPanel(new FlowLayout(0));
        this.m_DefaultBackground = this.m_PanelValue.getBackground();
        this.m_PanelValue.setBorder(BorderFactory.createLineBorder(this.m_DefaultBackground));
        panelAll.add((Component)this.m_PanelValue, "Center");
        this.m_TextValue = new JTextField(20);
        this.m_TextValue.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    RangeEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    RangeEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        this.m_TextValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                RangeEditor.this.indicateValidity();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RangeEditor.this.indicateValidity();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                RangeEditor.this.indicateValidity();
            }
        });
        JLabel label = new JLabel("Range");
        label.setDisplayedMnemonic('R');
        label.setLabelFor(this.m_TextValue);
        this.m_PanelValue.add(label);
        this.m_PanelValue.add(this.m_TextValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        JButton buttonOK = new JButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeEditor.this.acceptInput();
            }
        });
        panelButtons.add(buttonOK);
        JButton buttonClose = new JButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RangeEditor.this.discardInput();
            }
        });
        panelButtons.add(buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return this.parse(s) != null;
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((Range)this.getValue()).getRange());
    }

    protected void acceptInput() {
        String s = this.m_TextValue.getText();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue(this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    @Override
    protected void initForDisplay() {
        super.initForDisplay();
        String current = ((Range)this.getValue()).getRange();
        if (!this.m_TextValue.getText().equals(current)) {
            this.m_TextValue.setText(current);
        }
        this.m_TextValue.setToolTipText(((Range)this.getValue()).getExample());
        this.m_TextValue.grabFocus();
    }

    @Override
    public Object[] getSelectedObjects(Container parent) {
        Object[] result;
        MultiLineValueDialog dialog = new MultiLineValueDialog();
        dialog.setInfoText("Enter the ranges, one per line:");
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            Vector<String> lines = new Vector<String>(Arrays.asList(dialog.getContent().split("\n")));
            Utils.removeEmptyLines(lines);
            result = new Range[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                result[i] = this.parse(lines.get(i));
            }
        } else {
            result = new Range[]{};
        }
        return result;
    }

    @Override
    public boolean isInlineEditingAvailable() {
        return true;
    }

    @Override
    public void setInlineValue(String value) {
        if (this.isValid(value)) {
            this.setValue(this.parse(value));
        }
    }

    @Override
    public String getInlineValue() {
        return ((Range)this.getValue()).getRange();
    }

    @Override
    public boolean isInlineValueValid(String value) {
        return this.isValid(value);
    }

    protected void indicateValidity() {
        Color curColor = ((LineBorder)this.m_PanelValue.getBorder()).getLineColor();
        Color newColor = this.isValid(this.m_TextValue.getText()) ? this.m_DefaultBackground : Color.RED;
        if (!newColor.equals(curColor)) {
            this.m_PanelValue.setBorder(BorderFactory.createLineBorder(newColor));
        }
    }
}

