/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.scripting;

import adams.data.container.DataContainer;
import adams.data.filter.AbstractFilter;
import adams.db.DatabaseConnectionHandler;
import adams.gui.scripting.AbstractDataContainerUpdatingScriptlet;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.util.Vector;

public abstract class AbstractFilterScriptlet
extends AbstractDataContainerUpdatingScriptlet {
    private static final long serialVersionUID = -9200477598539423747L;

    @Override
    protected String getOptionsDescription() {
        return "<classname + options>";
    }

    public String process(String options, boolean overlay) throws Exception {
        int i;
        Object manager = this.getDataContainerPanel().getContainerManager();
        if (((VisibilityContainerManager)manager).countVisible() == 0) {
            return "No visible containers!";
        }
        Vector<DataContainer> runInput = new Vector<DataContainer>();
        for (i = 0; i < ((ContainerManager)manager).count(); ++i) {
            if (!((VisibilityContainerManager)manager).isVisible(i)) continue;
            runInput.add((DataContainer)((Container)((ContainerManager)manager).get(i)).getPayload());
        }
        AbstractFilter runScheme = AbstractFilter.forCommandLine(options);
        if (runScheme instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)((Object)runScheme)).setDatabaseConnection(this.getOwner().getDatabaseConnection());
        }
        this.addUndoPoint("Saving undo data...", "Filter: " + runScheme.getClass().getName().replaceAll(".*\\.", ""));
        this.showStatus("Filtering...");
        Vector<DataContainer> runOutput = AbstractFilter.filter(runScheme.shallowCopy(true), runInput);
        Vector<DataContainer> runOutputC = new Vector<DataContainer>();
        for (i = 0; i < runOutput.size(); ++i) {
            runOutputC.add(runOutput.get(i));
        }
        this.updateDataContainers(runOutputC, overlay);
        runScheme.destroy();
        this.showStatus("");
        return null;
    }
}

