/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.selection;

import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.selection.AbstractTableBasedSelectionPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public abstract class AbstractDatabaseSelectionPanel<T>
extends AbstractTableBasedSelectionPanel<T>
implements DatabaseConnectionChangeListener,
DatabaseConnectionHandler {
    private static final long serialVersionUID = 3870916380764854145L;
    protected JButton m_ButtonRefresh;
    protected boolean m_DataDisplayed;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DataDisplayed = false;
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection().getClone();
        this.m_DatabaseConnection.addChangeListener(this);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_ButtonRefresh = new JButton("Refresh");
        this.m_ButtonRefresh.setMnemonic('R');
        this.m_ButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDatabaseSelectionPanel.this.refresh();
            }
        });
        this.m_SearchPanel.addToWidgetsPanel(this.m_ButtonRefresh);
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.m_ButtonRefresh.setEnabled(value);
    }

    public abstract void refreshIfNecessary();

    protected abstract void doRefresh();

    public void refresh() {
        this.refresh((Object[])this.getCurrentItems().clone());
    }

    protected void refresh(final T[] items) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                AbstractDatabaseSelectionPanel.this.m_ButtonRefresh.setEnabled(false);
                AbstractDatabaseSelectionPanel.this.doRefresh();
                AbstractDatabaseSelectionPanel.this.m_Current = AbstractDatabaseSelectionPanel.this.select(items).toArray();
                AbstractDatabaseSelectionPanel.this.updateCounts();
                AbstractDatabaseSelectionPanel.this.m_ButtonRefresh.setEnabled(true);
                AbstractDatabaseSelectionPanel.this.m_DataDisplayed = true;
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void setItems(T[] value) {
        if (!this.waitForEnabled(this.m_ButtonRefresh)) {
            this.m_Current = (Object[])Array.newInstance(this.getItemClass(), value.length);
            for (int i = 0; i < value.length; ++i) {
                this.m_Current[i] = value[i];
            }
        } else if (!this.m_DataDisplayed) {
            this.refresh(value);
        } else {
            super.setItems(value);
        }
    }

    @Override
    public void setVisible(boolean value) {
        if (value && !this.m_DataDisplayed) {
            this.refresh();
        }
        super.setVisible(value);
    }

    public void addRefreshActionListener(ActionListener l) {
        this.m_ButtonRefresh.addActionListener(l);
    }

    public void removeRefreshActionListener(ActionListener l) {
        this.m_ButtonRefresh.removeActionListener(l);
    }

    protected void databaseConnected() {
        this.refresh();
    }

    protected abstract void databaseDisconnected();

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        this.m_Current = (Object[])Array.newInstance(this.getItemClass(), 0);
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
            this.databaseConnected();
        } else {
            this.databaseDisconnected();
        }
    }

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        if (value == null) {
            value = this.getDefaultDatabaseConnection();
        }
        if (!this.m_DatabaseConnection.equals(value)) {
            this.m_DataDisplayed = false;
            this.m_DatabaseConnection.removeChangeListener(this);
            this.m_DatabaseConnection = value.getClone();
            this.m_DatabaseConnection.addChangeListener(this);
            if (this.m_DatabaseConnection.isConnected()) {
                this.databaseConnected();
            } else {
                this.databaseDisconnected();
            }
        }
    }

    @Override
    protected void beforeShow() {
        super.beforeShow();
        this.m_ButtonRefresh.setEnabled(this.m_DatabaseConnection.isConnected());
        if (this.m_DatabaseConnection.isConnected()) {
            this.refreshIfNecessary();
        }
    }

    @Override
    public void cleanUp() {
        this.m_DatabaseConnection.removeChangeListener(this);
        super.cleanUp();
    }
}

