/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionHandler;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import adams.gui.tools.AbstractManagementPanel;
import javax.swing.SwingWorker;

public abstract class AbstractManagementPanelWithDatabase<T extends Comparable>
extends AbstractManagementPanel<T>
implements DatabaseConnectionHandler,
DatabaseConnectionChangeListener,
CleanUpHandler {
    private static final long serialVersionUID = 3181901882660335578L;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected abstract AbstractDatabaseConnection getDefaultDatabaseConnection();

    @Override
    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_DatabaseConnection;
    }

    @Override
    public void setDatabaseConnection(AbstractDatabaseConnection value) {
        this.m_DatabaseConnection.removeChangeListener(this);
        this.m_DatabaseConnection = value;
        this.m_DatabaseConnection.addChangeListener(this);
    }

    @Override
    public void databaseConnectionStateChanged(DatabaseConnectionChangeEvent e) {
        if (e.getType() == DatabaseConnectionChangeEvent.EventType.CONNECT) {
            this.setDatabaseConnection(e.getDatabaseConnection());
        }
        if (e.getDatabaseConnection().isConnected()) {
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    AbstractManagementPanelWithDatabase.this.m_ButtonRefresh.setEnabled(false);
                    AbstractManagementPanelWithDatabase.this.refresh();
                    return null;
                }

                @Override
                protected void done() {
                    AbstractManagementPanelWithDatabase.this.m_ButtonRefresh.setEnabled(true);
                    super.done();
                }
            };
            worker.execute();
        } else {
            this.m_ModelValues.clear();
        }
    }
}

