/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.NestedFormatHelper;
import adams.env.Environment;
import adams.gui.chooser.BaseFileChooser;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTree;
import adams.gui.core.BaseTreeNode;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.MouseUtils;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class NestedFormatViewerPanel
extends BasePanel
implements MenuBarProvider {
    private static final long serialVersionUID = -2759137600779907146L;
    protected BaseTree m_Tree;
    protected BaseFileChooser m_FileChooser;
    protected JMenuBar m_MenuBar;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new BaseFileChooser();
        ExtensionFileFilter filter = ExtensionFileFilter.getFlowFileFilter();
        this.m_FileChooser.addChoosableFileFilter(filter);
        this.m_FileChooser.setAcceptAllFileFilterUsed(true);
        this.m_FileChooser.setFileFilter(filter);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Tree = new BaseTree(new DefaultTreeModel(null));
        this.m_Tree.setCellRenderer(new Renderer());
        this.m_Tree.setShowsRootHandles(true);
        this.m_Tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isRightClick(e)) {
                    JPopupMenu menu = NestedFormatViewerPanel.this.createPopup(e);
                    if (menu != null) {
                        menu.show(NestedFormatViewerPanel.this.m_Tree, e.getX(), e.getY());
                    }
                    e.consume();
                } else {
                    super.mouseClicked(e);
                }
            }
        });
        this.add((Component)new BaseScrollPane(this.m_Tree), "Center");
    }

    protected JPopupMenu createPopup(MouseEvent e) {
        JPopupMenu result = null;
        final TreePath path = this.m_Tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            result = new JPopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon("copy.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseTreeNode node = (BaseTreeNode)path.getLastPathComponent();
                    GUIHelper.copyToClipboard(node.getUserObject().toString());
                }
            });
            result.add(menuitem);
        }
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    NestedFormatViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open file...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon("open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NestedFormatViewerPanel.this.openFile();
                }
            });
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon("exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NestedFormatViewerPanel.this.closeParent();
                }
            });
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
    }

    protected void openFile() {
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showOpenDialog(this);
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        this.openFile(this.m_FileChooser.getSelectedFile());
    }

    protected void buildTree(BaseTreeNode parent, List nested) {
        BaseTreeNode current = parent;
        for (int i = 0; i < nested.size(); ++i) {
            Object item = nested.get(i);
            if (item instanceof List) {
                this.buildTree(current, (List)item);
                continue;
            }
            BaseTreeNode child = new BaseTreeNode(item);
            parent.add(child);
            current = child;
        }
    }

    protected void openFile(File file) {
        List<String> lines = FileUtils.loadFromFile(file);
        Utils.removeComments(lines, "#");
        Utils.removeEmptyLines(lines);
        ArrayList nested = NestedFormatHelper.linesToNested(lines);
        BaseTreeNode root = new BaseTreeNode("<html><b>" + file.getName() + "</b></html>");
        this.buildTree(root, nested);
        this.m_Tree.setModel(new DefaultTreeModel(root));
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseFrame frame = new BaseFrame("Flow format viewer");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        NestedFormatViewerPanel panel = new NestedFormatViewerPanel();
        if (args.length > 0) {
            panel.openFile(new PlaceholderFile(args[0]));
        }
        frame.getContentPane().add((Component)panel, "Center");
        frame.setJMenuBar(panel.getMenuBar());
        frame.setSize(800, 600);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public class Renderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 8669721980782126964L;
        protected Hashtable<String, ImageIcon> m_Icons = new Hashtable();

        protected ImageIcon getIcon(String classname) {
            ImageIcon result = null;
            if (this.m_Icons.containsKey(classname)) {
                result = this.m_Icons.get(classname);
            } else {
                try {
                    result = GUIHelper.getIcon(classname + ".gif");
                    if (result == null) {
                        result = GUIHelper.getIcon(classname + ".png");
                    }
                    if (result == null) {
                        result = GUIHelper.getIcon(classname + ".jpg");
                    }
                }
                catch (Exception e) {
                    result = null;
                }
                if (result != null) {
                    this.m_Icons.put(classname, result);
                }
            }
            return result;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            ImageIcon icon = null;
            String str = value.toString();
            if (str.indexOf(46) > -1 && str.lastIndexOf(46) != str.indexOf(46)) {
                icon = this.getIcon(str);
            }
            this.setIcon(icon);
            return this;
        }
    }
}

