/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.SerializationHelper;
import adams.core.Utils;
import adams.gui.core.BaseTabbedPane;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.tools.previewbrowser.SerializedObjectPanel;
import java.io.File;

public class SerializedFileHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -1277627290853745369L;

    @Override
    public String globalInfo() {
        return "Displays serialized Java objects: " + Utils.arrayToString(this.getExtensions());
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"model", "model.gz"};
    }

    @Override
    protected PreviewPanel createPreview(File file) {
        Object[] objects;
        BaseTabbedPane tabbedPane = new BaseTabbedPane();
        try {
            objects = SerializationHelper.readAll(file.getAbsolutePath());
        }
        catch (Exception e) {
            this.getSystemErr().printStackTrace("Failed to read '" + file + "':", e);
            objects = new Object[]{Utils.throwableToString(e)};
        }
        for (Object obj : objects) {
            SerializedObjectPanel panel = new SerializedObjectPanel();
            panel.setCurrent(obj);
            tabbedPane.addTab("" + obj.getClass().getSimpleName(), panel);
        }
        return new PreviewPanel(tabbedPane);
    }
}

