/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.env.Environment;
import adams.gui.core.BasePanel;
import adams.gui.tools.previewbrowser.AbstractSerializedObjectViewer;
import adams.gui.tools.previewbrowser.DefaultSerializedObjectViewer;
import adams.gui.tools.previewbrowser.SerializedObjectViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SerializedObjectPanel
extends BasePanel
implements ActionListener {
    private static final long serialVersionUID = -4489513186403584128L;
    public static final String SESSION_FILE = "PreviewBrowserSerializedFileViewers.props";
    public static final String PREFIX_PREFERRED_VIEWER = "PreferredViewer";
    protected static Properties m_Properties;
    protected static SerializedObjectViewer[] m_Viewers;
    protected JPanel m_PanelView;
    protected JPanel m_PanelCombobox;
    protected JComboBox m_ComboBoxViewers;
    protected Object m_Current;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Current = null;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelView = new JPanel(new BorderLayout());
        this.add((Component)this.m_PanelView, "Center");
        this.m_PanelCombobox = new JPanel(new FlowLayout(0));
        this.add((Component)this.m_PanelCombobox, "South");
        this.m_ComboBoxViewers = new JComboBox();
        this.m_PanelCombobox.add(new JLabel("Preferred viewer"));
        this.m_PanelCombobox.add(this.m_ComboBoxViewers);
    }

    public void setCurrent(Object value) {
        this.m_Current = value;
        this.update();
    }

    public Object getCurrent() {
        return this.m_Current;
    }

    protected void update() {
        this.m_PanelView.removeAll();
        this.m_PanelCombobox.setVisible(false);
        if (this.m_Current == null) {
            return;
        }
        SerializedObjectViewer[] viewers = SerializedObjectPanel.getViewers();
        ArrayList<SerializedObjectViewer> list = new ArrayList<SerializedObjectViewer>();
        for (SerializedObjectViewer viewer : viewers) {
            if (viewer instanceof DefaultSerializedObjectViewer || !viewer.handles(this.m_Current)) continue;
            list.add(viewer);
        }
        if (list.size() == 0) {
            this.updateView(new DefaultSerializedObjectViewer());
        } else {
            this.m_PanelCombobox.setVisible(true);
            list.add(0, new DefaultSerializedObjectViewer());
            this.m_ComboBoxViewers.setModel(new DefaultComboBoxModel<SerializedObjectViewer>(list.toArray(new SerializedObjectViewer[list.size()])));
            this.m_ComboBoxViewers.addActionListener(this);
            SerializedObjectViewer preferred = this.getPreferredViewer(this.m_Current.getClass());
            if (preferred == null) {
                preferred = new DefaultSerializedObjectViewer();
            }
            int index = list.indexOf(preferred);
            this.m_ComboBoxViewers.setSelectedIndex(index);
            this.updateView((SerializedObjectViewer)list.get(index));
        }
    }

    protected void updateView(SerializedObjectViewer viewer) {
        this.m_PanelView.removeAll();
        this.m_PanelView.add((Component)viewer.getPreview(this.m_Current), "Center");
    }

    protected static synchronized SerializedObjectViewer[] getViewers() {
        if (m_Viewers == null) {
            String[] classnames = AbstractSerializedObjectViewer.getViewers();
            ArrayList<SerializedObjectViewer> viewers = new ArrayList<SerializedObjectViewer>();
            for (String classname : classnames) {
                try {
                    Class<?> cls = Class.forName(classname);
                    viewers.add((SerializedObjectViewer)cls.newInstance());
                }
                catch (Exception e) {
                    System.err.println("Failed to instantiate viewer '" + classname + "':");
                    e.printStackTrace();
                }
            }
            m_Viewers = viewers.toArray(new SerializedObjectViewer[viewers.size()]);
        }
        return m_Viewers;
    }

    protected SerializedObjectViewer getPreferredViewer(Class cls) {
        SerializedObjectViewer result = null;
        Properties props = SerializedObjectPanel.getProperties();
        if (props.hasKey("PreferredViewer-" + cls.getName())) {
            String viewer = props.getProperty("PreferredViewer-" + cls.getName());
            try {
                result = (SerializedObjectViewer)((Object)OptionUtils.forCommandLine(SerializedObjectViewer.class, viewer));
            }
            catch (Exception e) {
                System.err.println("Failed to instantiate viewer: " + viewer);
                e.printStackTrace();
            }
        }
        return result;
    }

    protected void updatePreferredViewer(Class cls, JComboBox combobox) {
        Properties props = SerializedObjectPanel.getProperties();
        SerializedObjectViewer viewer = combobox.getSelectedIndex() < 0 ? (SerializedObjectViewer)combobox.getItemAt(0) : (SerializedObjectViewer)combobox.getSelectedItem();
        props.setProperty("PreferredViewer-" + cls.getName(), OptionUtils.getCommandLine(viewer));
        String filename = Environment.getInstance().getHome() + File.separator + SESSION_FILE;
        if (!props.save(filename)) {
            System.err.println("Failed to save properties to '" + filename + "'!");
        }
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = new Properties();
            m_Properties.load(Environment.getInstance().getHome() + File.separator + SESSION_FILE);
        }
        return m_Properties;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_ComboBoxViewers.getSelectedIndex() == -1) {
            return;
        }
        SerializedObjectViewer viewer = (SerializedObjectViewer)this.m_ComboBoxViewers.getSelectedItem();
        this.updateView(viewer);
        this.updatePreferredViewer(this.m_Current.getClass(), this.m_ComboBoxViewers);
    }
}

