/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.container;

import adams.core.CleanUpHandler;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.MouseUtils;
import adams.gui.event.DataChangeEvent;
import adams.gui.event.DataChangeListener;
import adams.gui.visualization.container.AbstractContainerDisplayStringGenerator;
import adams.gui.visualization.container.AbstractContainerTableColumnNameGenerator;
import adams.gui.visualization.container.Container;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.ContainerModel;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.VisibilityContainerManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ContainerList<M extends ContainerManager, C extends Container>
extends BasePanel
implements CleanUpHandler,
TableModelListener,
ListSelectionListener,
DataChangeListener {
    private static final long serialVersionUID = -3486748595304948144L;
    protected ContainerTable<M, C> m_Table;
    protected ContainerListPopupMenuSupplier<M, C> m_PopupMenuSupplier;
    protected JLabel m_LabelTitle;
    protected String m_Title;
    protected HashSet<TableModelListener> m_TableModelListeners;
    protected HashSet<ListSelectionListener> m_ListSelectionListeners;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PopupMenuSupplier = null;
        this.m_TableModelListeners = new HashSet();
        this.m_ListSelectionListeners = new HashSet();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_LabelTitle = new JLabel();
        this.m_Table = this.createTable();
        this.m_Table.getModel().addTableModelListener(this);
        this.m_Table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ContainerList.this.m_PopupMenuSupplier != null && MouseUtils.isRightClick(e)) {
                    e.consume();
                    int row = ContainerList.this.m_Table.rowAtPoint(new Point(e.getX(), e.getY()));
                    JPopupMenu menu = ContainerList.this.m_PopupMenuSupplier.getContainerListPopupMenu(ContainerList.this.m_Table, row);
                    if (menu != null) {
                        menu.show(ContainerList.this.m_Table, e.getX(), e.getY());
                    }
                }
                if (!e.isConsumed()) {
                    super.mouseClicked(e);
                }
            }
        });
        this.add((Component)new BaseScrollPane(this.m_Table), "Center");
    }

    protected ContainerTable<M, C> createTable() {
        return new ContainerTable();
    }

    protected ContainerModel<M, C> createModel(M manager) {
        return new ContainerModel(manager);
    }

    protected void configureModel(ContainerModel<M, C> model) {
        model.setDisplayDatabaseID(this.getDisplayDatabaseID());
        model.setDisplayVisibility(this.getDisplayVisibility());
    }

    protected ContainerModel<M, C> newModel(M manager) {
        ContainerModel<M, C> result = this.createModel(manager);
        this.configureModel(result);
        return result;
    }

    protected ContainerModel<M, C> getContainerModel() {
        if (this.m_Table.getModel() instanceof ContainerModel) {
            return (ContainerModel)this.m_Table.getModel();
        }
        return null;
    }

    public void setManager(M value) {
        this.getContainerModel().removeTableModelListener(this);
        this.m_Table.getSelectionModel().removeListSelectionListener(this);
        if (this.getManager() != null) {
            ((ContainerManager)this.getManager()).removeDataChangeListener(this);
        }
        this.getContainerModel().cleanUp();
        this.m_Table.setModel(this.newModel(value));
        this.getContainerModel().addTableModelListener(this);
        this.m_Table.getSelectionModel().addListSelectionListener(this);
        ((ContainerManager)this.getManager()).addDataChangeListener(this);
    }

    public M getManager() {
        return this.getContainerModel().getManager();
    }

    public ContainerTable<M, C> getTable() {
        return this.m_Table;
    }

    public void setSelectionMode(int value) {
        this.getTable().setSelectionMode(value);
    }

    public int getSelectionMode() {
        return this.getTable().getSelectionModel().getSelectionMode();
    }

    public void setDisplayStringGenerator(AbstractContainerDisplayStringGenerator value) {
        this.getContainerModel().setDisplayStringGenerator(value);
    }

    public AbstractContainerDisplayStringGenerator getDisplayStringGenerator() {
        return this.getContainerModel().getDisplayStringGenerator();
    }

    public void setColumnNameGenerator(AbstractContainerTableColumnNameGenerator value) {
        this.getContainerModel().setColumnNameGenerator(value);
    }

    public AbstractContainerTableColumnNameGenerator getColumnNameGenerator() {
        return this.getContainerModel().getColumnNameGenerator();
    }

    public void setPopupMenuSupplier(ContainerListPopupMenuSupplier<M, C> value) {
        this.m_PopupMenuSupplier = value;
    }

    public ContainerListPopupMenuSupplier<M, C> getPopupMenuSupplier() {
        return this.m_PopupMenuSupplier;
    }

    public void setDisplayVisibility(boolean value) {
        this.getContainerModel().setDisplayVisibility(value);
        this.getTable().invalidateColumnWidths();
    }

    public boolean getDisplayVisibility() {
        return this.getContainerModel().getDisplayVisibility();
    }

    public void setDisplayDatabaseID(boolean value) {
        this.getContainerModel().setDisplayDatabaseID(value);
        this.getTable().invalidateColumnWidths();
    }

    public boolean getDisplayDatabaseID() {
        return this.getContainerModel().getDisplayDatabaseID();
    }

    public boolean hasTitle() {
        return this.m_Title.length() > 0;
    }

    public void setTitle(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Title = value;
        if (this.m_Title.length() == 0) {
            this.remove(this.m_LabelTitle);
        } else {
            this.add((Component)this.m_LabelTitle, "North");
        }
        this.updateTitle();
    }

    protected void updateTitle() {
        if (this.m_LabelTitle == null) {
            return;
        }
        M manager = this.getManager();
        String title = this.m_Title;
        if (manager != null) {
            title = title + " (";
            if (manager instanceof VisibilityContainerManager) {
                title = title + ((VisibilityContainerManager)manager).countVisible() + "/";
            }
            title = title + ((ContainerManager)manager).count();
            title = title + ")";
        }
        this.m_LabelTitle.setText(title);
    }

    public String getTitle() {
        String result = null;
        if (this.hasTitle()) {
            result = this.m_Title;
        }
        return result;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        for (TableModelListener l : this.m_TableModelListeners) {
            l.tableChanged(e);
        }
    }

    public void addTableModelListener(TableModelListener l) {
        this.m_TableModelListeners.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.m_TableModelListeners.remove(l);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        for (ListSelectionListener l : this.m_ListSelectionListeners) {
            l.valueChanged(e);
        }
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.m_ListSelectionListeners.add(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        this.m_ListSelectionListeners.remove(l);
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        this.updateTitle();
    }

    @Override
    public void cleanUp() {
        this.getContainerModel().removeTableModelListener(this);
        this.m_Table.getSelectionModel().removeListSelectionListener(this);
        this.getContainerModel().cleanUp();
        this.m_TableModelListeners.clear();
        this.m_ListSelectionListeners.clear();
    }
}

