/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.core;

import adams.gui.core.BasePanel;
import adams.gui.event.PaintEvent;
import adams.gui.event.PaintListener;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.core.PlotPanel;
import java.awt.Graphics;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;

public abstract class PaintablePanel
extends BasePanel
implements PaintListener {
    private static final long serialVersionUID = -1394066820727332049L;
    protected HashSet<Paintlet> m_Paintlets;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Paintlets = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPaintlet(Paintlet p) {
        HashSet<Paintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            this.m_Paintlets.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePaintlet(Paintlet p) {
        HashSet<Paintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            this.m_Paintlets.remove(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<Paintlet> paintlets() {
        HashSet<Paintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            return this.m_Paintlets.iterator();
        }
    }

    public abstract PlotPanel getPlot();

    protected abstract void prepareUpdate();

    protected void performUpdate() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PaintablePanel.this.validate();
                PaintablePanel.this.repaint();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void postUpdate() {
    }

    public synchronized void update() {
        this.prepareUpdate();
        this.performUpdate();
        this.postUpdate();
    }

    protected abstract boolean canPaint(Graphics var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paint(Graphics g, PaintEvent.PaintMoment moment) {
        HashSet<Paintlet> hashSet = this.m_Paintlets;
        synchronized (hashSet) {
            for (Paintlet paintlet : this.m_Paintlets) {
                if (!paintlet.canPaint(moment)) continue;
                paintlet.performPaint(g, moment);
            }
        }
    }

    @Override
    public void painted(PaintEvent e) {
        Graphics g = e.getGraphics();
        if (!this.canPaint(g)) {
            return;
        }
        this.paint(g, e.getPaintMoment());
    }
}

