/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.sequence;

import adams.core.Properties;
import adams.core.option.OptionUtils;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.sequence.XYSequence;
import adams.data.sequence.XYSequencePoint;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.gui.chooser.BaseDirectoryChooser;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import adams.gui.core.Undo;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.dialog.SpreadSheetDialog;
import adams.gui.event.PaintListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.scripting.AbstractScriptingEngine;
import adams.gui.scripting.ScriptingEngine;
import adams.gui.visualization.container.ContainerListPopupMenuSupplier;
import adams.gui.visualization.container.ContainerManager;
import adams.gui.visualization.container.ContainerTable;
import adams.gui.visualization.container.DataContainerPanelWithSidePanel;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.core.AbstractPaintlet;
import adams.gui.visualization.core.AntiAliasingPaintlet;
import adams.gui.visualization.core.CoordinatesPaintlet;
import adams.gui.visualization.core.DefaultColorProvider;
import adams.gui.visualization.core.PlotPanel;
import adams.gui.visualization.core.PopupMenuCustomizer;
import adams.gui.visualization.core.plot.AbstractHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.core.plot.TipTextCustomizer;
import adams.gui.visualization.sequence.AbstractXYSequencePaintlet;
import adams.gui.visualization.sequence.PaintletWithFixedXRange;
import adams.gui.visualization.sequence.PaintletWithFixedYRange;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerList;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequenceStickPaintlet;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class XYSequencePanel
extends DataContainerPanelWithSidePanel<XYSequence, XYSequenceContainerManager>
implements PaintListener,
ContainerListPopupMenuSupplier<XYSequenceContainerManager, XYSequenceContainer>,
PopupMenuCustomizer,
TipTextCustomizer {
    private static final long serialVersionUID = 7985845939008731534L;
    protected XYSequenceContainerList m_SequenceContainerList;
    protected XYSequencePaintlet m_XYSequencePaintlet;
    protected CoordinatesPaintlet m_CoordinatesPaintlet;
    protected Undo m_Undo;
    protected boolean m_AdjustToVisibleData;
    protected boolean m_AllowResize;
    protected BaseDirectoryChooser m_DirChooser;
    protected SpreadSheetFileChooser m_FileChooser;
    protected GenericObjectEditorDialog m_WriterDialog;
    protected SpreadSheetDialog m_ViewDialog;

    public XYSequencePanel() {
    }

    public XYSequencePanel(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        this.m_Undo = null;
        this.m_AdjustToVisibleData = true;
        this.m_AllowResize = false;
        super.initialize();
    }

    @Override
    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    @Override
    protected XYSequenceContainerManager newContainerManager() {
        return new XYSequenceContainerManager(this);
    }

    @Override
    public XYSequencePaintlet getContainerPaintlet() {
        return this.m_XYSequencePaintlet;
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        Properties props = this.getProperties();
        this.setAdjustToVisibleData(props.getBoolean("Plot.AdjustToVisibleData", false));
        this.m_SequenceContainerList = new XYSequenceContainerList();
        this.m_SequenceContainerList.setManager(this.getContainerManager());
        this.m_SequenceContainerList.setPopupMenuSupplier(this);
        this.m_SidePanel.setLayout(new GridLayout(1, 1));
        this.m_SidePanel.add(this.m_SequenceContainerList);
        this.getPlot().setPopupMenuCustomizer(this);
        this.getPlot().setTipTextCustomizer(this);
        this.m_XYSequencePaintlet = new XYSequenceStickPaintlet();
        if (this.m_XYSequencePaintlet instanceof AntiAliasingPaintlet) {
            ((AntiAliasingPaintlet)((Object)this.m_XYSequencePaintlet)).setAntiAliasingEnabled(props.getBoolean("Plot.AntiAliasing", true));
        }
        this.m_XYSequencePaintlet.setPanel(this);
        this.setPaintlet((AbstractXYSequencePaintlet)AbstractPaintlet.forCommandLine(props.getString("Plot.Paintlet", new XYSequenceStickPaintlet().toCommandLine())));
        this.m_CoordinatesPaintlet = new CoordinatesPaintlet();
        this.m_CoordinatesPaintlet.setYInvisible(true);
        this.m_CoordinatesPaintlet.setPanel(this);
        this.m_CoordinatesPaintlet.setXColor(props.getColor("Plot.CoordinatesColor." + (Object)((Object)CoordinatesPaintlet.Coordinates.X), Color.DARK_GRAY));
        this.m_CoordinatesPaintlet.setYColor(props.getColor("Plot.CoordinatesColor." + (Object)((Object)CoordinatesPaintlet.Coordinates.Y), Color.DARK_GRAY));
        try {
            ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider((AbstractColorProvider)OptionUtils.forAnyCommandLine(AbstractColorProvider.class, props.getProperty("Plot.ColorProvider", "adams.gui.visualization.core.DefaultColorProvider")));
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + " - Failed to set the color provider:");
            ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider(new DefaultColorProvider());
        }
    }

    public ContainerManager getSequenceManager() {
        return this.m_Manager;
    }

    public void setPaintlet(XYSequencePaintlet value) {
        this.removePaintlet(this.m_XYSequencePaintlet);
        this.m_XYSequencePaintlet = value;
        this.m_XYSequencePaintlet.setPanel(this);
        this.update();
    }

    public XYSequencePaintlet getPaintlet() {
        return this.m_XYSequencePaintlet;
    }

    public void setUndo(Undo value) {
        this.m_Undo = value;
    }

    public Undo getUndo() {
        return this.m_Undo;
    }

    public boolean isUndoSupported() {
        return this.m_Undo != null;
    }

    @Override
    protected boolean canPaint(Graphics g) {
        return this.getPlot() != null && this.m_Manager != null;
    }

    public void setAdjustToVisibleData(boolean value) {
        this.m_AdjustToVisibleData = value;
        this.update();
    }

    public boolean getAdjustToVisibleData() {
        return this.m_AdjustToVisibleData;
    }

    @Override
    public void prepareUpdate() {
        double maxY;
        double minY;
        double maxX;
        double minX;
        boolean determineXRange;
        boolean determineYRange = !(this.m_XYSequencePaintlet instanceof PaintletWithFixedYRange);
        boolean bl = determineXRange = !(this.m_XYSequencePaintlet instanceof PaintletWithFixedXRange);
        if (determineXRange) {
            minX = Double.MAX_VALUE;
            maxX = -1.7976931348623157E308;
        } else {
            minX = ((PaintletWithFixedXRange)((Object)this.m_XYSequencePaintlet)).getMinX();
            maxX = ((PaintletWithFixedXRange)((Object)this.m_XYSequencePaintlet)).getMaxX();
        }
        if (determineYRange) {
            minY = Double.MAX_VALUE;
            maxY = -1.7976931348623157E308;
        } else {
            minY = ((PaintletWithFixedYRange)((Object)this.m_XYSequencePaintlet)).getMinY();
            maxY = ((PaintletWithFixedYRange)((Object)this.m_XYSequencePaintlet)).getMaxY();
        }
        if (determineXRange || determineYRange) {
            for (int i = 0; i < ((XYSequenceContainerManager)this.getContainerManager()).count(); ++i) {
                XYSequence seq;
                if (this.m_AdjustToVisibleData && !((XYSequenceContainerManager)this.getContainerManager()).isVisible(i) || (seq = ((XYSequenceContainer)((XYSequenceContainerManager)this.getContainerManager()).get(i)).getData()).size() == 0) continue;
                if (determineXRange) {
                    minX = Math.min(minX, XYSequencePoint.toDouble(seq.getMinX().getX()));
                    maxX = Math.max(maxX, XYSequencePoint.toDouble(seq.getMaxX().getX()));
                }
                if (!determineYRange) continue;
                minY = Math.min(minY, XYSequencePoint.toDouble(seq.getMinY().getY()));
                maxY = Math.max(maxY, XYSequencePoint.toDouble(seq.getMaxY().getY()));
            }
        }
        if (minX == maxX) {
            minX -= 1.0;
            maxX += 1.0;
        }
        this.getPlot().getAxis(Axis.LEFT).setMinimum(minY);
        this.getPlot().getAxis(Axis.LEFT).setMaximum(maxY);
        this.getPlot().getAxis(Axis.BOTTOM).setMinimum(minX);
        this.getPlot().getAxis(Axis.BOTTOM).setMaximum(maxX);
    }

    @Override
    public void customizePopupMenu(MouseEvent e, JPopupMenu menu) {
        JMenuItem item;
        AntiAliasingPaintlet paintlet;
        if (this.m_XYSequencePaintlet instanceof XYSequenceLinePaintlet) {
            paintlet = (XYSequenceLinePaintlet)this.m_XYSequencePaintlet;
            item = new JMenuItem();
            if (!((XYSequenceLinePaintlet)paintlet).isMarkersDisabled()) {
                item.setText("Disable markers");
            } else {
                item.setText("Enable markers");
            }
            item.addActionListener(new ActionListener((XYSequenceLinePaintlet)paintlet){
                final /* synthetic */ XYSequenceLinePaintlet val$paintlet;
                {
                    this.val$paintlet = xYSequenceLinePaintlet;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.val$paintlet.setMarkersDisabled(!this.val$paintlet.isMarkersDisabled());
                    XYSequencePanel.this.repaint();
                }
            });
            menu.add(item);
        }
        if (this.m_XYSequencePaintlet instanceof AntiAliasingPaintlet) {
            paintlet = (AntiAliasingPaintlet)((Object)this.m_XYSequencePaintlet);
            item = new JMenuItem();
            if (paintlet.isAntiAliasingEnabled()) {
                item.setText("Disable anti-aliasing");
            } else {
                item.setText("Enable anti-aliasing");
            }
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    paintlet.setAntiAliasingEnabled(!paintlet.isAntiAliasingEnabled());
                    XYSequencePanel.this.repaint();
                }
            });
            menu.add(item);
        }
        if (this.getAllowResize()) {
            item = new JMenuItem("Resize...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    XYSequencePanel.this.showResizeDialog();
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem();
        if (this.isSidePanelVisible()) {
            item.setText("Hide side panel");
        } else {
            item.setText("Show side panel");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.setSidePanelVisible(!XYSequencePanel.this.isSidePanelVisible());
            }
        });
        menu.add(item);
        item = new JMenuItem();
        if (this.m_AdjustToVisibleData) {
            item.setText("Adjust to loaded data");
        } else {
            item.setText("Adjust to visible data");
        }
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.m_AdjustToVisibleData = !XYSequencePanel.this.m_AdjustToVisibleData;
                XYSequencePanel.this.update();
            }
        });
        if (!(this.m_XYSequencePaintlet instanceof PaintletWithFixedYRange)) {
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem("Save visible sequences...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.saveVisibleSequences();
            }
        });
        menu.add(item);
    }

    @Override
    public JPopupMenu getContainerListPopupMenu(ContainerTable table, int row) {
        JPopupMenu result = new JPopupMenu();
        final ContainerTable tableF = table;
        final int rowF = row;
        final int[] selectedF = table.getSelectedRows();
        JMenuItem item = new JMenuItem("Toggle visibility");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF};
                }
                for (int i = 0; i < indices.length; ++i) {
                    XYSequenceContainer c;
                    c.setVisible(!(c = (XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(indices[i])).isVisible());
                }
            }
        });
        result.add(item);
        item = new JMenuItem("Choose color...");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c;
                String msg = "Choose color";
                XYSequenceContainer cont = null;
                Color color = Color.BLUE;
                if (selectedF.length == 1) {
                    cont = (XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(selectedF[0]);
                    msg = msg + " for " + cont.getData().getID();
                    color = cont.getColor();
                }
                if ((c = JColorChooser.showDialog(tableF, msg, color)) == null) {
                    return;
                }
                for (int i : selectedF) {
                    ((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(i)).setColor(c);
                }
            }
        });
        result.add(item);
        result.addSeparator();
        item = new JMenuItem("Remove");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] indices = tableF.getSelectedRows();
                if (indices.length == 0) {
                    indices = new int[]{rowF + 1};
                }
                XYSequencePanel.this.m_SequenceContainerList.getTable().removeContainers(indices);
            }
        });
        result.add(item);
        item = new JMenuItem("Remove all");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.m_SequenceContainerList.getTable().removeAllContainers();
            }
        });
        result.add(item);
        result.addSeparator();
        item = new JMenuItem("Save as...");
        item.setEnabled(tableF.getSelectedRowCount() == 1);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.saveSequence((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(tableF.getSelectedRow()));
            }
        });
        result.add(item);
        item = new JMenuItem("View as table");
        item.setEnabled(tableF.getSelectedRowCount() == 1);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XYSequencePanel.this.viewSequence((XYSequenceContainer)((XYSequenceContainerManager)XYSequencePanel.this.getContainerManager()).get(tableF.getSelectedRow()));
            }
        });
        result.add(item);
        return result;
    }

    protected void saveVisibleSequences() {
        int retval;
        if (this.m_DirChooser == null) {
            this.m_DirChooser = new BaseDirectoryChooser();
        }
        if ((retval = this.m_DirChooser.showSaveDialog(this)) != 0) {
            return;
        }
        if (this.m_WriterDialog == null) {
            this.m_WriterDialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_WriterDialog.setTitle("Select spreadsheet writer");
            this.m_WriterDialog.getGOEEditor().setClassType(SpreadSheetWriter.class);
            this.m_WriterDialog.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_WriterDialog.setCurrent(new CsvSpreadSheetWriter());
            this.m_WriterDialog.setLocationRelativeTo(this);
        }
        this.m_WriterDialog.setVisible(true);
        if (this.m_WriterDialog.getResult() != 0) {
            return;
        }
        SpreadSheetWriter writer = (SpreadSheetWriter)this.m_WriterDialog.getCurrent();
        String prefix = this.m_DirChooser.getSelectedFile().getAbsolutePath();
        for (int i = 0; i < ((XYSequenceContainerManager)this.getContainerManager()).count(); ++i) {
            if (!((XYSequenceContainerManager)this.getContainerManager()).isVisible(i)) continue;
            XYSequence seq = ((XYSequenceContainer)((XYSequenceContainerManager)this.getContainerManager()).get(i)).getData();
            writer.write(seq.toSpreadSheet(), prefix + File.separator + seq.getID() + "." + writer.getFormatExtensions()[0]);
        }
    }

    protected void saveSequence(XYSequenceContainer cont) {
        VFSJFileChooser.RETURN_TYPE retVal;
        if (this.m_FileChooser == null) {
            this.m_FileChooser = new SpreadSheetFileChooser();
        }
        if ((retVal = this.m_FileChooser.showSaveDialog(this)) != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        XYSequence seq = cont.getData();
        SpreadSheetWriter writer = this.m_FileChooser.getWriter();
        if (!writer.write(seq.toSpreadSheet(), this.m_FileChooser.getSelectedFile())) {
            GUIHelper.showErrorMessage(this, "Failed to save sequence to file:\n" + this.m_FileChooser.getSelectedFile());
        }
    }

    protected void viewSequence(XYSequenceContainer cont) {
        if (this.m_ViewDialog == null) {
            this.m_ViewDialog = this.getParentDialog() != null ? new SpreadSheetDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new SpreadSheetDialog(this.getParentFrame(), true);
            this.m_ViewDialog.setTitle("Sequence: " + cont.getDisplayID());
            this.m_ViewDialog.setSize(400, 600);
            this.m_ViewDialog.setLocationRelativeTo(this);
        }
        XYSequence seq = cont.getData();
        this.m_ViewDialog.setSpreadSheet(seq.toSpreadSheet());
        this.m_ViewDialog.setVisible(true);
    }

    @Override
    public String processTipText(PlotPanel panel, Point mouse, String tiptext) {
        String hit;
        String result = tiptext;
        MouseEvent event = new MouseEvent(this.getPlot().getContent(), 503, new Date().getTime(), 0, (int)mouse.getX(), (int)mouse.getY(), 0, false);
        if (this.m_XYSequencePaintlet instanceof HitDetectorSupporter && (hit = (String)((AbstractHitDetector)((HitDetectorSupporter)((Object)this.m_XYSequencePaintlet)).getHitDetector()).detect(event)) != null) {
            result = result + hit;
        }
        return result;
    }

    public XYSequenceContainerList getContainerList() {
        return this.m_SequenceContainerList;
    }

    @Override
    public AbstractScriptingEngine getScriptingEngine() {
        return ScriptingEngine.getSingleton(this.getDatabaseConnection());
    }

    public void setAllowResize(boolean value) {
        this.m_AllowResize = value;
    }

    public boolean getAllowResize() {
        return this.m_AllowResize;
    }

    protected void showResizeDialog() {
        ApprovalDialog dialog = this.getParentDialog() != null ? ApprovalDialog.getDialog(this.getParentDialog()) : ApprovalDialog.getDialog(this.getParentFrame());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Resizing plot");
        ParameterPanel paramPanel = new ParameterPanel();
        dialog.getContentPane().add((Component)paramPanel, "Center");
        JSpinner spinnerWidth = new JSpinner();
        ((SpinnerNumberModel)spinnerWidth.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)spinnerWidth.getModel()).setStepSize(10);
        ((SpinnerNumberModel)spinnerWidth.getModel()).setValue(this.getPlot().getContent().getWidth());
        paramPanel.addParameter("_Width", spinnerWidth);
        JSpinner spinnerHeight = new JSpinner();
        ((SpinnerNumberModel)spinnerHeight.getModel()).setMinimum(Integer.valueOf(1));
        ((SpinnerNumberModel)spinnerHeight.getModel()).setStepSize(10);
        ((SpinnerNumberModel)spinnerHeight.getModel()).setValue(this.getPlot().getContent().getHeight());
        paramPanel.addParameter("_Height", spinnerHeight);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        if (dialog.getOption() == 0) {
            this.resizePlot(new Dimension(((Number)spinnerWidth.getValue()).intValue(), ((Number)spinnerHeight.getValue()).intValue()));
        }
    }

    public void resizePlot(Dimension size) {
        Dimension current = this.getPlot().getContent().getSize();
        int width = size.width - current.width;
        int height = size.height - current.height;
        current = null;
        if (this.getParentDialog() != null) {
            current = this.getParentDialog().getSize();
        } else if (this.getParentFrame() != null) {
            current = this.getParentFrame().getSize();
        } else if (this.getParentInternalFrame() != null) {
            current = this.getParentInternalFrame().getSize();
        }
        if (current != null) {
            Dimension newSize = new Dimension(current.width + width, current.height + height);
            if (this.getParentDialog() != null) {
                this.getParentDialog().setSize(newSize);
            } else if (this.getParentFrame() != null) {
                this.getParentFrame().setSize(newSize);
            } else if (this.getParentInternalFrame() != null) {
                this.getParentInternalFrame().setSize(newSize);
            }
        }
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.m_DirChooser != null) {
            this.m_DirChooser = null;
        }
        if (this.m_FileChooser != null) {
            this.m_FileChooser = null;
        }
        if (this.m_WriterDialog != null) {
            this.m_WriterDialog.dispose();
            this.m_WriterDialog = null;
        }
        if (this.m_ViewDialog != null) {
            this.m_ViewDialog.dispose();
        }
        this.m_ViewDialog = null;
    }
}

