/*
 * Decompiled with CFR 0.152.
 */
package adams.parser;

import adams.data.spreadsheet.SpreadSheet;
import adams.parser.AbstractSymbolEvaluator;
import adams.parser.spreadsheetformula.Parser;
import adams.parser.spreadsheetformula.Scanner;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java_cup.runtime.DefaultSymbolFactory;
import java_cup.runtime.SymbolFactory;

public class SpreadSheetFormula
extends AbstractSymbolEvaluator<Double> {
    private static final long serialVersionUID = 8014316012335802585L;
    protected SpreadSheet m_Sheet;

    @Override
    public String globalInfo() {
        return "Evaluates mathematical expressions.\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    @Override
    public String getGrammar() {
        return "expr_list ::= '=' expr_list expr_part | expr_part ;\nexpr_part ::= expr ;\n\nnumexpr   ::=   ( numexpr )\n              |  NUMBER\n              | -numexpr\n              | constexpr\n              | opexpr\n              | funcexpr\n              ;\n\n strexpr  ::=   substr ( strexpr , start )\n              | substr ( strexpr , start , end )\n              | lowercase ( strexpr )\n              | uppercase ( strexpr )\n              | trim ( strexpr )\n              | string\n              ;\n\nconstexpr ::=   PI\n              | E\n              ;\n\nopexpr    ::=   numexpr + numexpr\n              | numexpr - numexpr\n              | numexpr * numexpr\n              | numexpr / numexpr\n              | numexpr ^ numexpr (power of)\n              | numexpr % numexpr (modulo)\n              ;\n\nfuncexpr ::=    abs ( numexpr | cell )\n              | sqrt ( numexpr | cell )\n              | log ( numexpr | cell )\n              | exp ( numexpr | cell )\n              | sin ( numexpr | cell )\n              | cos ( numexpr | cell )\n              | tan ( numexpr | cell )\n              | rint ( numexpr | cell )\n              | floor ( numexpr | cell )\n              | pow ( numexpr | cell , numexpr | cell )\n              | ceil ( numexpr | cell )\n              | ifelse ( boolexpr , numexpr (if true) , numexpr (if false) )\n              | length ( str )\n              | sum ( cell1 : cell2 )\n              | min ( cell1 : cell2 )\n              | max ( cell1 : cell2 )\n              | average ( cell1 : cell2 )\n              | stdev ( cell1 : cell2 )\n              | stdevp ( cell1 : cell2 )\n              | countif ( cell1 : cell2 ; numexpr )\n              | countif ( cell1 : cell2 ; stringexpr )\n              ;\n\nboolexpr ::=    ( boolexpr )\n              | true\n              | false\n              | numexpr &lt; numexpr\n              | numexpr &lt;= numexpr\n              | numexpr &gt; numexpr\n              | numexpr &gt;= numexpr\n              | numexpr = numexpr\n              | numexpr != numexpr (or: numexpr <> numexpr)\n              | strexpr < strexpr\n              | strexpr <= strexpr\n              | strexpr > strexpr\n              | strexpr >= strexpr\n              | strexpr = strexpr\n              | strexpr != strexpr (or: strexpr <> strexpr)\n              | matches ( strexpr , regexp )\n              | ! boolexpr (or: not boolexpr)\n              | boolexpr & boolexpr (or: boolexpr and boolexpr)\n              | boolexpr | boolexpr (or: boolexpr or boolexpr)\n              ;\n\nNotes:\n- Cells are denoted by column in letter and row in digit, e.g., 'C12'.\n- 'start' and 'end' for function 'substr' are indices that start at 1.\n- Index 'end' for function 'substr' is excluded (like Java's 'String.substring(int,int)' method)\n- Line comments start with '#'.\n- Semi-colons (';') or commas (',') can be used as separator in the formulas,\n  e.g., 'pow(2,2)' is equivalent to 'pow(2;2)'\n";
    }

    @Override
    protected String getDefaultExpression() {
        return "= 42";
    }

    @Override
    public String expressionTipText() {
        return "The spreadsheet formula to evaluate (must evaluate to a double).";
    }

    public void setSheet(SpreadSheet value) {
        this.m_Sheet = value;
    }

    public SpreadSheet getSheet() {
        return this.m_Sheet;
    }

    @Override
    protected Object initializeSymbol(String name, String value) {
        Double result;
        try {
            result = new Double(value);
        }
        catch (Exception e) {
            result = null;
            this.getSystemErr().println("Failed to parse the value of symbol '" + name + "': " + value);
            this.getSystemErr().printStackTrace(e);
        }
        return result;
    }

    @Override
    protected Double doEvaluate(HashMap symbols) throws Exception {
        return SpreadSheetFormula.evaluate(this.m_Expression, symbols, this.m_Sheet);
    }

    public static double evaluate(String expr, HashMap symbols, SpreadSheet sheet) throws Exception {
        if ((expr = expr.trim()).startsWith("=")) {
            expr = expr.substring(1);
        }
        DefaultSymbolFactory sf = new DefaultSymbolFactory();
        ByteArrayInputStream parserInput = new ByteArrayInputStream(expr.getBytes());
        Parser parser = new Parser(new Scanner(parserInput, (SymbolFactory)sf), (SymbolFactory)sf);
        parser.setSymbols(symbols);
        parser.setSheet(sheet);
        parser.parse();
        return parser.getResult();
    }

    public static void main(String[] args) {
        SpreadSheetFormula.runEvaluator(SpreadSheetFormula.class, args);
    }
}

