/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.AbstractActor;
import adams.flow.core.Capability;
import adams.flow.core.Token;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import weka.core.Capabilities;

public abstract class AbstractAttributeCapabilities
extends AbstractBooleanCondition {
    private static final long serialVersionUID = 3278345095591806425L;
    protected Capability[] m_Capabilities;
    protected boolean m_Invert;
    protected Capabilities m_ActualCapabilities;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("capability", "capabilities", (Object)new Capability[0]);
        this.m_OptionManager.add("invert", "invert", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_ActualCapabilities = null;
    }

    public void setCapabilities(Capability[] value) {
        this.m_Capabilities = value;
        this.reset();
    }

    public Capability[] getCapabilities() {
        return this.m_Capabilities;
    }

    public String capabilitiesTipText() {
        return "The capabilities that the objects must match.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then objects that failed the capabilities test will pass through and all others get discarded.";
    }

    public String getQuickInfo() {
        return (this.m_Invert ? "! " : "") + QuickInfoHelper.toString((OptionHandler)this, (String)"capabilities", (Object)Utils.shorten((String)Utils.arrayToString((Object)this.m_Capabilities), (int)50));
    }

    public abstract Class[] accepts();

    public String setUp(AbstractActor owner) {
        String result = super.setUp(owner);
        if (result == null) {
            this.m_ActualCapabilities = new Capabilities(null);
            HashSet<Capability> capabilities = new HashSet<Capability>(Arrays.asList(this.m_Capabilities));
            for (Capability c : this.m_Capabilities) {
                this.m_ActualCapabilities.enable(Capability.toWeka(c));
            }
            HashSet<Capabilities.Capability> unwanted = new HashSet<Capabilities.Capability>();
            Iterator iter = this.m_ActualCapabilities.capabilities();
            while (iter.hasNext()) {
                Capabilities.Capability cap = (Capabilities.Capability)iter.next();
                if (capabilities.contains((Object)Capability.toAdams(cap))) continue;
                unwanted.add(cap);
            }
            for (Capabilities.Capability c : unwanted) {
                this.m_ActualCapabilities.disable(c);
            }
            if (this.isDebugOn()) {
                this.debug("Capabilites: " + this.m_ActualCapabilities);
            }
        }
        return result;
    }

    protected abstract boolean doEvaluate(AbstractActor var1, Token var2);
}

