/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.AbstractParameter;

public abstract class AbstractWekaSetupGenerator<T>
extends AbstractSource {
    private static final long serialVersionUID = 673114129476898021L;
    protected boolean m_OutputArray;
    protected SetupGenerator m_Generator;
    protected Vector<T> m_Setups;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("setup", "setup", this.getDefaultSetup());
        this.m_OptionManager.add("parameter", "parameters", (Object)this.getDefaultParameters());
        this.m_OptionManager.add("array", "outputArray", (Object)false);
    }

    protected abstract T getDefaultSetup();

    protected abstract AbstractParameter[] getDefaultParameters();

    protected String getDefaultPackage() {
        String result = this.getDefaultSuperClass().getPackage().getName();
        result = result.substring(0, result.lastIndexOf(46));
        return result;
    }

    protected abstract Class getDefaultSuperClass();

    protected void initialize() {
        super.initialize();
        this.m_Generator = new SetupGenerator();
        this.m_Setups = new Vector();
    }

    public void setParameters(AbstractParameter[] value) {
        this.m_Generator.setParameters(value);
        this.reset();
    }

    public AbstractParameter[] getParameters() {
        return this.m_Generator.getParameters();
    }

    public String parametersTipText() {
        return "The parameters to use for generating the setups.";
    }

    public void setOutputArray(boolean value) {
        this.m_OutputArray = value;
        this.reset();
    }

    public boolean getOutputArray() {
        return this.m_OutputArray;
    }

    public String outputArrayTipText() {
        return "If set to true, then an array of setups will be output instead of a sequence.";
    }

    public String getQuickInfo() {
        String result = null;
        if (this.m_Generator.getBaseObject() != null) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"setup", this.m_Generator.getBaseObject().getClass());
            if (this.m_Generator.getParameters() != null) {
                result = result + "/" + this.m_Generator.getParameters().length + " parameter" + (this.m_Generator.getParameters().length == 1 ? "" : "s");
            }
        }
        return result;
    }

    public Class[] generates() {
        if (this.m_OutputArray) {
            return new Class[]{Array.newInstance(this.getDefaultSuperClass(), 0).getClass()};
        }
        return new Class[]{this.getDefaultSuperClass()};
    }

    protected String doExecute() {
        String result = null;
        this.m_Setups.clear();
        Enumeration<Serializable> setups = this.m_Generator.setups();
        if (setups != null) {
            boolean noSetups = true;
            while (setups.hasMoreElements()) {
                noSetups = false;
                this.m_Setups.add(setups.nextElement());
            }
            if (noSetups) {
                result = "No setups generated!";
            }
        } else {
            result = "Error encountered in setup generation!";
        }
        return result;
    }

    public Token output() {
        Token result;
        if (this.m_OutputArray) {
            result = new Token((Object)this.m_Setups.toArray((Object[])Array.newInstance(this.getDefaultSuperClass(), this.m_Setups.size())));
            this.m_Setups.clear();
        } else {
            result = new Token(this.m_Setups.get(0));
            this.m_Setups.remove(0);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Setups.size() > 0;
    }

    public void wrapUp() {
        this.m_Setups.clear();
        super.wrapUp();
    }
}

