/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.rules.ZeroR;

public class WekaClassifierSetup
extends AbstractSource {
    private static final long serialVersionUID = -3019442578354930841L;
    protected Classifier m_Classifier;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Outputs an instance of the specified classifier.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("classifier", "classifier", (Object)new ZeroR());
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
        this.reset();
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String classifierTipText() {
        return "The Weka classifier to train on the input data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"classifier", (Object)Utils.shorten((String)OptionUtils.getShortCommandLine((Object)this.m_Classifier), (int)40));
    }

    public Class[] generates() {
        return new Class[]{Classifier.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Classifier cls = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of classifier:", e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

