/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.source.AbstractSource;
import weka.core.Instances;
import weka.datagenerators.DataGenerator;
import weka.datagenerators.classifiers.classification.Agrawal;

public class WekaDataGenerator
extends AbstractSource
implements ProvenanceSupporter {
    private static final long serialVersionUID = 1862828539481494711L;
    protected DataGenerator m_DataGenerator;
    protected transient Token m_OutputToken;

    public String globalInfo() {
        return "Generates artificial data using a Weka data generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "dataGenerator", (Object)new Agrawal());
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)Utils.shorten((String)OptionUtils.getShortCommandLine((Object)this.m_DataGenerator), (int)40));
    }

    public void setDataGenerator(DataGenerator value) {
        this.m_DataGenerator = value;
        this.reset();
    }

    public DataGenerator getDataGenerator() {
        return this.m_DataGenerator;
    }

    public String dataGeneratorTipText() {
        return "The data generator to use for generating the weka.core.Instances object.";
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    protected String doExecute() {
        String result = null;
        this.m_OutputToken = null;
        try {
            this.m_DataGenerator.setDatasetFormat(this.m_DataGenerator.defineDataFormat());
            Instances data = this.m_DataGenerator.generateExamples();
            if (data == null) {
                result = "No data obtained from data generator!";
            } else {
                this.m_OutputToken = new Token((Object)data);
            }
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate data: ", e);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

