/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorHelper;
import adams.flow.core.GlobalActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import weka.core.Instance;

public abstract class AbstractProcessWekaInstanceWithModel<T>
extends AbstractTransformer {
    private static final long serialVersionUID = -5275241130624220000L;
    public static final String BACKUP_MODEL = "model";
    protected PlaceholderFile m_ModelFile;
    protected GlobalActorReference m_ModelActor;
    protected T m_Model;
    protected boolean m_OnTheFly;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_MODEL, "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new GlobalActorReference());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelFile = value;
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelFile;
    }

    public String modelFileTipText() {
        return "The model file to load (when not pointing to a directory).";
    }

    public void setModelActor(GlobalActorReference value) {
        this.m_ModelActor = value;
        this.reset();
    }

    public GlobalActorReference getModelActor() {
        return this.m_ModelActor;
    }

    public String modelActorTipText() {
        return "The global actor to use for obtaining the model in case serialized model file points to a directory.";
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)(this.m_ModelFile.isDirectory() ? this.m_ModelActor : this.m_ModelFile));
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public abstract Class[] generates();

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_MODEL);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Model != null) {
            result.put(BACKUP_MODEL, this.m_Model);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_MODEL)) {
            this.m_Model = state.get(BACKUP_MODEL);
            state.remove(BACKUP_MODEL);
        }
        super.restoreState(state);
    }

    protected String setUpModel() {
        String result = null;
        if (this.m_ModelFile.isDirectory()) {
            try {
                this.m_Model = GlobalActorHelper.getSetup(null, (GlobalActorReference)this.m_ModelActor, (AbstractActor)this);
            }
            catch (Exception e) {
                this.m_Model = null;
                result = this.handleException("Failed to obtain model from global actor '" + this.m_ModelActor + "': ", e);
            }
        } else {
            try {
                this.m_Model = SerializationHelper.read((String)this.m_ModelFile.getAbsolutePath());
            }
            catch (Exception e) {
                this.m_Model = null;
                result = this.handleException("Failed to load model from '" + this.m_ModelFile + "': ", e);
            }
        }
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel();
        }
        return result;
    }

    protected abstract Token processInstance(Instance var1) throws Exception;

    protected String doExecute() {
        String result = null;
        if (this.m_OnTheFly && (result = this.setUpModel()) != null) {
            return result;
        }
        Instance inst = null;
        try {
            inst = (Instance)this.m_InputToken.getPayload();
            this.m_OutputToken = this.processInstance(inst);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            this.handleException("Failed to process instance: " + inst, e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Model = null;
    }
}

