/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.flow.core.AbstractActor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.provenance.ProvenanceSupporter;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public class WekaInstancesAppend
extends AbstractTransformer
implements ProvenanceSupporter {
    private static final long serialVersionUID = -268487303904639474L;

    public String globalInfo() {
        return "Creates one large dataset by appending all one after the other.";
    }

    public Class[] accepts() {
        return new Class[]{String[].class, File[].class, Instances[].class};
    }

    public Class[] generates() {
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        int i;
        String result = null;
        File[] files = null;
        Instances[] inst = null;
        if (this.m_InputToken.getPayload() instanceof String[]) {
            String[] filesStr = (String[])this.m_InputToken.getPayload();
            files = new File[filesStr.length];
            for (i = 0; i < filesStr.length; ++i) {
                files[i] = new PlaceholderFile(filesStr[i]);
            }
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof Instances[]) {
            inst = (Instances[])this.m_InputToken.getPayload();
        } else {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        if (files != null) {
            inst = new Instances[files.length];
            for (i = 0; i < files.length; ++i) {
                try {
                    inst[i] = ConverterUtils.DataSource.read((String)files[i].getAbsolutePath());
                    continue;
                }
                catch (Exception e) {
                    result = this.handleException("Failed to load dataset: " + files[i], e);
                    break;
                }
            }
        }
        if (result == null) {
            for (i = 0; i < inst.length - 1; ++i) {
                for (int n = i + 1; n < inst.length; ++n) {
                    String msg = inst[i].equalHeadersMsg(inst[n]);
                    if (msg == null) continue;
                    result = "Dataset #" + (i + 1) + " and #" + (n + 1) + " are not compatible:\n" + msg;
                    break;
                }
                if (result != null) break;
            }
        }
        if (result == null) {
            Instances full = new Instances(inst[0]);
            StringBuilder relation = new StringBuilder(inst[0].relationName());
            for (i = 1; i < inst.length; ++i) {
                relation.append("+" + inst[i].relationName());
                for (Instance row : inst[i]) {
                    full.add(row);
                }
            }
            full.setRelationName(relation.toString());
            this.m_OutputToken = new Token((Object)full);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            cont.addProvenance(new ProvenanceInformation(ActorType.DATAGENERATOR, this.m_InputToken.getPayload().getClass(), (AbstractActor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

